"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var getUnZippedLength = function (input) {
    var e_1, _a;
    var maxLength = 0;
    try {
        for (var input_1 = __values(input), input_1_1 = input_1.next(); !input_1_1.done; input_1_1 = input_1.next()) {
            var item = input_1_1.value;
            if (Array.isArray(item) && item.length > maxLength) {
                maxLength = item.length;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (input_1_1 && !input_1_1.done && (_a = input_1.return)) _a.call(input_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return maxLength;
};
/**
 * 这个方法类似于_.zip，除了它接收分组元素的数组，并且创建一个数组，分组元素到打包前的结构。
 * 返回数组的第一个元素包含所有的输入数组的第一元素，第一个元素包含了所有的输入数组的第二元素，依此类推。
 *
 * @param input(array) 要处理的分组元素数组。
 * @returns array 返回重组元素的新数组。
 *
 * @example
 * var zipped = _.zip(['fred', 'barney'], [30, 40], [true, false]);
 * // => [['fred', 30, true], ['barney', 40, false]]
 *
 * _.unzip(zipped);
 * // => [['fred', 'barney'], [30, 40], [true, false]]
 */
function unzip(input) {
    var e_2, _a;
    if (!Array.isArray(input)) {
        return [];
    }
    var result = [];
    var unzippedLength = getUnZippedLength(input);
    for (var i = 0; i < unzippedLength; i++) {
        var tempRes = [];
        try {
            for (var input_2 = (e_2 = void 0, __values(input)), input_2_1 = input_2.next(); !input_2_1.done; input_2_1 = input_2.next()) {
                var item = input_2_1.value;
                if (Array.isArray(item)) {
                    tempRes.push(item[i]);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (input_2_1 && !input_2_1.done && (_a = input_2.return)) _a.call(input_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        result.push(tempRes);
    }
    return result;
}
exports.default = unzip;
