import { TargetTaskService } from '@ohos/hvigor-ohos-plugin/src/tasks/service/target-task-service.js';
import { LegacyHapPlugin } from '@ohos/hvigor-ohos-plugin/src/plugin/legacy/legacy-hap-plugin.js';
/**
 * ArkUI跨平台plugin对外暴露hap级别的接口和任务的plugin
 * 继承了ohos-plugin的能力，且对部分Task进行hook，处理ArkUI跨平台相关逻辑
 *
 * @since 2022/11/24
 */
export declare class CrossplatformHapPlugin {
    private readonly log;
    private _needExecTargetServiceList;
    private _projectModel;
    private _moduleModel;
    private _module;
    private assembleHap;
    private hapPlugin;
    constructor(hapPlugin: LegacyHapPlugin);
    initHookTask(): void;
    hookAssembleHap(): void;
    initAndroidTasks(targetTaskService: TargetTaskService): void;
    initIosTasks(targetTaskService: TargetTaskService): void;
    addOhosTargetCompile(): Promise<void>;
    /**
     * 跨平台工程规格前置检查
     * 校验不通过时，不挂载跨平台任务
     *
     * @return {boolean} true校验通过，false校验不通过
     */
    preCheck(): boolean;
    /**
     * 模块级规格校验
     * 校验不通过时两种情况：
     * 1. 校验报错，构建终止
     * 2. 校验不通过时，不挂载跨平台处理任务
     *
     * @return {boolean} true校验通过， false校验不通过
     */
    moduleVerification(): boolean;
    private checkModule;
}
