"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stack = void 0;
var ListCache_1 = __importDefault(require("./ListCache"));
var MapCache_1 = __importDefault(require("./MapCache"));
var LARGE_ARRAY_SIZE = 200;
var Stack = /** @class */ (function () {
    function Stack(entries) {
        this.wdkData = new ListCache_1.default(entries);
        var data = this.wdkData;
        this.size = data.size;
    }
    Stack.prototype.clear = function () {
        this.wdkData = new ListCache_1.default(undefined);
        this.size = 0;
    };
    Stack.prototype.delete = function (key) {
        var data = this.wdkData;
        var result = data.delete(key);
        this.size = data.size;
        return result;
    };
    Stack.prototype.get = function (key) {
        return this.wdkData.get(key);
    };
    Stack.prototype.has = function (key) {
        return this.wdkData.has(key);
    };
    Stack.prototype.set = function (key, value) {
        var data = this.wdkData;
        if (data instanceof ListCache_1.default) {
            var pairs = data.wdkData;
            if (pairs.length < LARGE_ARRAY_SIZE - 1) {
                pairs.push([key, value]);
                this.size = ++data.size;
                return this;
            }
            this.wdkData = new MapCache_1.default(pairs);
            data = this.wdkData;
        }
        data.set(key, value);
        this.size = data.size;
        return this;
    };
    return Stack;
}());
exports.Stack = Stack;
