"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assignValue = exports.baseAssignValue = void 0;
var validCheck_1 = require("./validCheck");
function baseAssignValue(object, key, value) {
    if (key === '__proto__') {
        Object.defineProperty(object, key, {
            configurable: true,
            enumerable: true,
            value: value,
            writable: true,
        });
    }
    else {
        object[key] = value;
    }
}
exports.baseAssignValue = baseAssignValue;
var hasOwnProperty = Object.prototype.hasOwnProperty;
/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
    var objValue = object[key];
    if (!(hasOwnProperty.call(object, key) && (0, validCheck_1.isEqual)(objValue, value))
        || (value === undefined && !(key in object))) {
        baseAssignValue(object, key, value);
    }
}
exports.assignValue = assignValue;
