"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var arrayLikeKeys_1 = __importDefault(require("./common/arrayLikeKeys"));
var isNil_1 = __importDefault(require("./isNil"));
function keys(object) {
    if ((0, isNil_1.default)(object)) {
        return [];
    }
    return (0, isArrayLike_1.default)(object)
        ? (0, arrayLikeKeys_1.default)(object, undefined)
        : Object.keys(Object(object));
}
exports.default = keys;
