"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 转换string字符串为指定基数的整数。
 * 如果基数是 undefined 或者 0，则radix基数默认是10，如果string字符串是16进制，则radix基数为 16。
 *
 * @param input(string): 要转换的字符串
 * @param radix(number): 转换基数
 * @returns (number): 返回转换后的整数
 *
 * @example
 * _.parseInt('08');
 * // => 8
 *
 * _.map(['6', '08', '10'], _.parseInt);
 * // => [6, 8, 10]
 */
function parseInt(input, radix) {
    try {
        return Number.parseInt(input, radix);
    }
    catch (e) {
        return Number.NaN;
    }
}
exports.default = parseInt;
