"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNaN_1 = __importDefault(require("./isNaN"));
var toNumber_1 = __importDefault(require("./toNumber"));
var floor_1 = require("./floor");
/**
 * 四舍五入
 * @param input
 * @param precision
 */
function round(input, precision) {
    if (precision === void 0) { precision = 0; }
    if (typeof Number(input) !== 'number') {
        return Number.NaN;
    }
    if (input === Number.MAX_SAFE_INTEGER || input === Number.MIN_SAFE_INTEGER) {
        return input;
    }
    var newPrecision = (0, isNaN_1.default)(precision) ? 0 : Math.floor((0, toNumber_1.default)(precision));
    var newInput = Number(input);
    if (newPrecision === 0) {
        return Math.round(newInput);
    }
    var baseNumber = Math.pow(10, Math.abs(newPrecision));
    if (baseNumber === Number.POSITIVE_INFINITY || baseNumber === Number.NEGATIVE_INFINITY) {
        return input;
    }
    if (newInput >= 0 && (1 / newInput > 0)) {
        if (newPrecision > 0) {
            return Math.round((0, floor_1.numMulti)(Math.abs(newInput), baseNumber)) / baseNumber;
        }
        if (newPrecision < 0) {
            return (0, floor_1.numMulti)(Math.round(Math.abs(newInput) / baseNumber), baseNumber);
        }
    }
    else {
        if (newPrecision > 0) {
            return -(Math.round((0, floor_1.numMulti)(Math.abs(newInput), baseNumber)) / baseNumber);
        }
        if (newPrecision < 0) {
            return -(0, floor_1.numMulti)(Math.round(Math.abs(newInput) / baseNumber), baseNumber);
        }
    }
    return input;
}
exports.default = round;
