"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var utils_1 = require("./common/utils");
/**
 * 返回collection（集合）的长度，如果集合是类数组或字符串，返回其 length ；如果集合是对象，返回其可枚举属性的个数。
 *
 * 参数
 *   1.collection (Array|Object): 要检查的集合
 * 返回
 *   (number): 返回集合的长度。
 *
 * @category Collection
 * @param collection 集合
 * @returns {number} 返回集合的大小.
 * @example
 *
 * size([1, 2, 3])
 * // => 3
 *
 * size({ 'a': 1, 'b': 2 })
 * // => 2
 *
 * size('pebbles')
 * // => 7
 */
function size(collection) {
    if (collection === null || collection === undefined) {
        return 0;
    }
    if ((0, isArrayLike_1.default)(collection)) {
        return collection.length;
    }
    var tag = (0, utils_1.tagName)(collection);
    if (tag === '[object Map]' || tag === '[object Set]') {
        return collection.size;
    }
    return Object.keys(collection).length;
}
exports.default = size;
