/**
 * 将指定字符串拆分成单词数组。
 *
 * @since 1.0.0
 * @param {string} [str=''] 待转换的字符串
 * @param {RegExp|string} [pattern] 匹配规则
 * @returns {Array} 单词数组。
 * @example
 *
 * words('fred, barney, & pebbles')
 * // => ['fred', 'barney', 'pebbles']
 *
 * words('fred, barney, & pebbles', /[^, ]+/g)
 * // => ['fred', 'barney', '&', 'pebbles']
 */
declare function words(str?: string, pattern?: any): RegExpMatchArray;
export default words;
