"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 创建一个给定数组中唯一值（即未重复出现）组成的新数组。新数组中元素的顺序取决于他们在原数组的出现顺序。
 * @param rawArraysAndComparator，
 * （多个）原数组和comparator
 * comparator用于比较两个元素是否等同，等同认为则重复出现
 *
 * @return 给定数组中唯一值组成的新数组
 * @example
 * baseXor([1.1,2.2,2.3] ,[1.4,3.6] ,(e1,e2)=>Math.floor(e1)===Math.floor(e2)) = [2.2, 3.6];
 * 解释执行逻辑：先对每个数组内去重，2.2和2.3经过comparator后认为等同，得到 [1.1,2.2]和[1.4,3.6]，拼接后再去重，得到最后结果[2.2,3.6]
 */
function xorWith() {
    var rawArraysAndComparator = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        rawArraysAndComparator[_i] = arguments[_i];
    }
    var rawArrays = rawArraysAndComparator;
    var comparator = function (e1, e2) { return e1 === e2; };
    var length = rawArraysAndComparator.length;
    var lastEle = rawArraysAndComparator[length - 1];
    if (typeof lastEle === 'function') {
        rawArrays = rawArraysAndComparator.slice(0, length - 1);
        comparator = lastEle;
    }
    if (!rawArrays || rawArrays.length === 0) {
        return [];
    }
    var arrays = rawArrays.filter(function (rawInput) { return Array.isArray(rawInput) || Object.prototype.toString.call(rawInput) === '[object Arguments]'; }); // 过滤非数组非argument类型的输入
    var deduplicatedArrs = arrays.map(function (_arr) {
        var arr = __spreadArray([], __read(_arr), false); // _arr可能是Arguments类型，需要转为可遍历的数组
        var newArr = [];
        arr.forEach(function (el) {
            var found = newArr.find(function (newEl) { return comparator(newEl, el); });
            if (!found) {
                newArr.push(el);
            }
        });
        return newArr;
    }); // 对每一个输入的数组去重
    // 所有去重后的数组拼接在一起
    var concatedArray = deduplicatedArrs.reduce(function (accumulator, curArr) { return __spreadArray(__spreadArray([], __read(accumulator), false), __read(curArr), false); });
    var result = [];
    concatedArray.forEach(function (el, index) {
        var cloneArr = __spreadArray([], __read(concatedArray), false);
        cloneArr.splice(index, 1);
        var found = cloneArr.find(function (otherEl) { return comparator(otherEl, el); });
        if (!found) {
            result.push(el);
        }
    });
    return result; // 返回最终结果，即出现次数只为1的元素组成的数组
}
exports.default = xorWith;
