"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.DaemonServerSocketListenerRegistry=void 0;const cluster_1=__importDefault(require("cluster")),process_1=__importDefault(require("process")),util_1=__importDefault(require("util")),build_event_js_1=require("../../common/daemon-protocol/build-event.js"),common_enum_js_1=require("../../common/daemon-protocol/common-enum.js"),message_js_1=require("../../common/daemon-protocol/message.js"),global_data_js_1=require("../../internal/data/global-data.js"),event_id_options_js_1=require("../../internal/lifecycle/event/event-id-options.js"),hvigor_log_js_1=require("../../log/hvigor-log.js"),time_util_js_1=require("../../util/time-util.js"),worker_process_event_id_js_1=require("../cluster/worker-process-event-id.js"),hvigor_daemon_log_js_1=require("../log/hvigor-daemon-log.js"),daemon_process_lifecycle_js_1=require("../process/daemon-process-lifecycle.js"),daemon_info_js_1=require("../registry/daemon-info.js"),hvigor_daemon_server_js_1=require("../server/hvigor-daemon-server.js"),session_manager_js_1=require("../session/session-manager.js"),daemon_server_socket_handler_js_1=require("./daemon-server-socket-handler.js"),_log=hvigor_daemon_log_js_1.HvigorDaemonLogger.getLogger("daemon");class DaemonServerSocketListenerRegistry{constructor(e){this.socket=e}registryBaseListener(e){this.onStartBuild(e),this.onCancel(),this.onStop(),this.onError(),this.onDisconnected(e)}onStartBuild(e){this.socket.on(build_event_js_1.BuildEvent.COMMON_BUILD,(async s=>{var t;if(!s){const e="hvigor daemon: Received client exception type information. Empty build arguments.";return void this.socket.emit(build_event_js_1.BuildEvent.BUILD_STATUS,(0,message_js_1.createBuildStatus)(common_enum_js_1.BuildStatus.REJECT,-1,e))}const o=process_1.default.hrtime(),r=s;try{(0,global_data_js_1.initStartData)(r)}catch(e){return _log.error(e),void this.socket.emit(build_event_js_1.BuildEvent.BUILD_STATUS,(0,message_js_1.createBuildStatus)(common_enum_js_1.BuildStatus.REJECT,-1,null!==(t=e.stack)&&void 0!==t?t:e.message))}if((0,hvigor_log_js_1.evaluateLogLevel)(global_data_js_1.startParameters.logLevel,["daemon"]),session_manager_js_1.defaultSessionManager.getActiveSocket()&&(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()!==daemon_info_js_1.DaemonState.HALF_BUSY||(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()===daemon_info_js_1.DaemonState.STOP_REQ||(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()===daemon_info_js_1.DaemonState.BUSY){const e="hvigor daemon: Current process status is busy, cannot start a build action. Please wait a moment and retry.";return _log.error(e),void this.socket.emit(build_event_js_1.BuildEvent.BUILD_STATUS,(0,message_js_1.createBuildStatus)(common_enum_js_1.BuildStatus.REJECT,0,e))}session_manager_js_1.defaultSessionManager.setActiveSocket(this.socket),(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()===daemon_info_js_1.DaemonState.HALF_BUSY&&(0,daemon_process_lifecycle_js_1.setCurrentProcessState)(daemon_info_js_1.DaemonState.STOP_REQ),_log.debug(`hvigor daemon: Receive data from client. data=${util_1.default.format(s)}.`),_log.debug("hvigor daemon: Build start."),(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()===daemon_info_js_1.DaemonState.STOP_REQ&&(0,daemon_process_lifecycle_js_1.setCurrentProcessState)(daemon_info_js_1.DaemonState.BUSY);const{exitCode:_,reason:i}=await this.awaitBuildResult(r);(0,daemon_process_lifecycle_js_1.resetProcessTimeOutTimer)(e),(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()===daemon_info_js_1.DaemonState.BUSY&&(0,daemon_process_lifecycle_js_1.setCurrentProcessState)(daemon_info_js_1.DaemonState.HALF_BUSY),_log.debug(`hvigor daemon: Build end. endTime=${(0,time_util_js_1.formatTime)(process_1.default.hrtime(o))}`),this.socket.emit(build_event_js_1.BuildEvent.BUILD_STATUS,(0,message_js_1.createBuildStatus)(common_enum_js_1.BuildStatus.FINISH,_,i))}))}async awaitBuildResult(e){let[s,t]=[0,void 0];if(cluster_1.default.isMaster){const o=await async function(){let e=Object.values(cluster_1.default.workers)[0];return e&&e.isConnected()&&!e.isDead()||(_log.debug("hvigor daemon: no worker before build. Build after starting a new worker process."),e=cluster_1.default.fork(),e.process.stdout.pipe(process_1.default.stdout),e.process.stderr.pipe(process_1.default.stderr),await new Promise((s=>{null==e||e.once("online",s)}))),e}();await new Promise((r=>{session_manager_js_1.defaultSessionManager.bindProcess(this.socket.id,o.id);const _=e=>{if(e.type){if(e.type===worker_process_event_id_js_1.WORKER_PROCESS_EVENT_ID.FINISHED)s=0,_log.debug(`hvigor daemon: worker process ${o.process.pid} finished. Build Finished.`);else{if(e.type!==worker_process_event_id_js_1.WORKER_PROCESS_EVENT_ID.FAILED)return;s=-1,_log.debug(`hvigor daemon: worker process ${o.process.pid} finished. Build Failed.`),t=e.content}o.off("exit",i),o.off("message",_),r()}},i=(e,t)=>{_log.debug(`hvigor daemon: worker process ${o.process.pid} exit (${e||t}). Build Failed.`),s=e,o.off("message",_),r()};o.on("message",_),o.once("exit",i),o.send({type:build_event_js_1.BuildEvent.COMMON_BUILD,content:e})}))}return{exitCode:s,reason:t}}onCancel(){this.socket.on(build_event_js_1.BuildEvent.CANCEL_BUILD,(e=>{if(!e)return void(0,daemon_server_socket_handler_js_1.handleClientMsgError)(_log,e);const s=e;_log.info(util_1.default.format(s)),this.stopTask(),this.socket.emit(common_enum_js_1.BuildStatus.CLOSE,(0,message_js_1.createBuildStatus)(common_enum_js_1.BuildStatus.CLOSE,0)),session_manager_js_1.defaultSessionManager.resetActiveSocket()}))}onStop(){this.socket.on(build_event_js_1.BuildEvent.STOP_DAEMON,(e=>{if(!e)return void(0,daemon_server_socket_handler_js_1.handleClientMsgError)(_log,e);const s=e;_log.info(util_1.default.format(s)),process_1.default.exit()}))}onError(){this.socket.on("error",(e=>{_log.error("error",e),this.stopTask()}))}onDisconnected(e){this.socket.on("disconnect",(s=>{_log.debug("hvigor disconnect: ",s),this.stopTask(),e.emit(hvigor_daemon_server_js_1.DaemonServerEventName.CLOSE_CONNECTION,this.socket)}))}stopTask(){var e;(null===(e=session_manager_js_1.defaultSessionManager.getActiveSocket())||void 0===e?void 0:e.id)===this.socket.id&&session_manager_js_1.defaultSessionManager.postMessageToThread(this.socket.id,{type:event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FAILED}),session_manager_js_1.defaultSessionManager.postMessageToThread(this.socket.id,{type:build_event_js_1.WatchEvent.CLOSE_WATCH})}}exports.DaemonServerSocketListenerRegistry=DaemonServerSocketListenerRegistry;