/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
 */

const {IncrementalTask} = require('@ohos/hvigor-base/src/external/task/incremental-task');
const path = require('path');
const fs = require('fs');
const {FileSet} = require('@ohos/hvigor-base/src/internal/snapshot/util/file-set');
let project = require('@ohos/hvigor')(__filename);

project.task(() => {
  console.log('This is a clean task');
}, 'clean');

class Copy extends IncrementalTask {

  constructor() {
    super(project,'copy');
    this.packageJsonPath = path.resolve('error.json');
    console.log(this.packageJsonPath);
    this.outputPackageJsonPath = path.resolve('build','package.json');
  }

  declareInputFiles() {
    return new FileSet().addEntry(this.packageJsonPath);
  }

  declareOutputFiles() {
    return new FileSet().addEntry(this.outputPackageJsonPath);
  }

  registryAction() {
    return () => {
      if (fs.existsSync(this.packageJsonPath)) {
        fs.copyFileSync(this.packageJsonPath, this.outputPackageJsonPath);
      }
    };
  }
}

project.registry(new Copy());