"use strict";
/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addModule = exports.writeFileContent = void 0;
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const json5_reader_1 = require("../../../../src/base/util/json5-reader");
function writeFileContent(filePath, content) {
    if (!fs_extra_1.default.existsSync(filePath)) {
        return;
    }
    fs_extra_1.default.writeFileSync(filePath, content);
}
exports.writeFileContent = writeFileContent;
function addModule(projectRootPath, moduleName) {
    const buildProfilePath = path_1.default.resolve(projectRootPath, 'build-profile.json5');
    const projectStructureOpt = json5_reader_1.Json5Reader.getJson5Obj(buildProfilePath);
    const modules = projectStructureOpt.modules;
    modules.push({
        name: moduleName,
        srcPath: `./${moduleName}`
    });
    writeFileContent(buildProfilePath, JSON.stringify(projectStructureOpt));
}
exports.addModule = addModule;
//# sourceMappingURL=common.js.map