import { Log } from '../utils/Log';
const log = new Log('AVPBase');
const preparedListenerMap = new WeakMap();
const onInfoListenerMap = new WeakMap();
const onRenderingStartListenerMap = new WeakMap();
const onStateChangedListenerMap = new WeakMap();
const onCompletionListenerMap = new WeakMap();
const onLoadingStatusListenerMap = new WeakMap();
const onErrorListenerMap = new WeakMap();
const onVideoSizeChangedListenerMap = new WeakMap();
const onSeekCompleteListenerMap = new WeakMap();
const onSubtitleDisplayListenerMap = new WeakMap();
const onVideoRenderedListenerMap = new WeakMap();
const onAudioInterruptEventListenerMap = new WeakMap();
const onTrackReadyListenerMap = new WeakMap();
const onSubTrackReadyListenerMap = new WeakMap();
const onSwichStreamListenerMap = new WeakMap();
const onAVNotSyncStatusListenerMap = new WeakMap();
const onTrackChangedListenerMap = new WeakMap();
const onSnapShotListenerMap = new WeakMap();
const onSeiDataListenerMap = new WeakMap();
const onNetworkStatusMap = new WeakMap();
const onUrlExpiredListenerMap = new WeakMap();
export class AVPBase {
    constructor(d19, e19) {
        this.mOutMediaInfo = null;
        this.mOutSubMediaInfo = null;
        this.mOutOnPreparedListener = null;
        this.mInnerOnPreparedListener = new InnerPrepareListener(this);
        this.mOutOnInfoListener = null;
        this.mInnerOnInfoListener = new InnerInfoListener(this);
        this.mOutOnRenderingStartListener = null;
        this.mInnerOnRenderingStartListener = new InnerRenderingStartListener(this);
        this.mOutOnStateChangedListener = null;
        this.mInnerOnStateChangedListener = new InnerStateChangedListener(this);
        this.mOutOnVideoSizeChangedListener = null;
        this.mInnerOnVideoSizeChangedListener = new InnerVideoSizeChangedListener(this);
        this.mOutOnLoadingStatusListener = null;
        this.mInnerOnLoadingStatusListener = new InnerLoadingStatusListener(this);
        this.mOutOnSeekCompleteListener = null;
        this.mInnerOnSeekCompleteListener = new InnerSeekCompleteListener(this);
        this.mOutOnCompletionListener = null;
        this.mInnerOnCompletionListener = new InnerCompletionListener(this);
        this.mOutOnVideoRenderedListener = null;
        this.mInnerOnVideoRenderedListener = new InnerVideoRenderedListener(this);
        this.mOutOnSubtitleDisplayListener = null;
        this.mInnerOnSubtitleDisplayListener = new InnerSubtitleDisplayListener(this);
        this.mOutOnErrorListener = null;
        this.mInnerOnErrorListener = new InnerErrorListener(this);
        this.mOutOnAudioInterruptEventListener = null;
        this.mInnerOnAudioInterruptEventListener = new InnerAudioInterruptEventListener(this);
        this.mOutOnTrackReadyListener = null;
        this.mInnerOnTrackReadyListener = new InnerTrackReadyListener(this);
        this.mOutOnSubTrackReadyListener = null;
        this.mInnerOnSubTrackReadyListener = new InnerSubTrackReadyListener(this);
        this.mOutOnStreamSwitchedListener = null;
        this.mInnerOnStreamSwitchedListener = new InnerStreamSwitchedListener(this);
        this.mOutOnAVNotSyncStatusListener = null;
        this.mInnerOnAVNotSyncStatusListener = new InnerOnAVNotSyncStatusListener(this);
        this.mOutOnNetworkStatsListener = null;
        this.mInnerOnNetworkStatsListener = new InnerOnNetworkStatsListener(this);
        this.mOutOnTrackChangedListener = null;
        this.mInnerOnTrackChangedListener = new InnerTrackChangedListener(this);
        this.mOutOnSnapShotListener = null;
        this.mInnerOnSnapShotListener = new InnerSnapShotListener(this);
        this.mOutOnSeiDataListener = null;
        this.mInnerOnSeiDataListener = new InnerSeiDataListener(this);
        this.mOutOnUrlExpiredListener = null;
        this.mInnerOnUrlExpiredListener = new InnerUrlExpiredListener(this);
        this.mInnerHasListenerCallback = new InnerHasListenerCallback(this);
        this.mContext = d19;
        this.mTraceId = e19;
        this.mCorePlayer = this.createAlivcMediaPlayer(d19);
        this.mCorePlayer.setTraceId(this.mTraceId);
        preparedListenerMap.set(this, this.mInnerOnPreparedListener);
        onInfoListenerMap.set(this, this.mInnerOnInfoListener);
        onRenderingStartListenerMap.set(this, this.mInnerOnRenderingStartListener);
        onStateChangedListenerMap.set(this, this.mInnerOnStateChangedListener);
        onCompletionListenerMap.set(this, this.mInnerOnCompletionListener);
        onLoadingStatusListenerMap.set(this, this.mInnerOnLoadingStatusListener);
        onErrorListenerMap.set(this, this.mInnerOnErrorListener);
        onVideoSizeChangedListenerMap.set(this, this.mInnerOnVideoSizeChangedListener);
        onSeekCompleteListenerMap.set(this, this.mInnerOnSeekCompleteListener);
        onSubtitleDisplayListenerMap.set(this, this.mInnerOnSubtitleDisplayListener);
        onVideoRenderedListenerMap.set(this, this.mInnerOnVideoRenderedListener);
        onAudioInterruptEventListenerMap.set(this, this.mInnerOnAudioInterruptEventListener);
        onTrackReadyListenerMap.set(this, this.mInnerOnTrackReadyListener);
        onSubTrackReadyListenerMap.set(this, this.mInnerOnSubTrackReadyListener);
        onSwichStreamListenerMap.set(this, this.mInnerOnStreamSwitchedListener);
        onAVNotSyncStatusListenerMap.set(this, this.mInnerOnAVNotSyncStatusListener);
        onNetworkStatusMap.set(this, this.mInnerOnNetworkStatsListener);
        onTrackChangedListenerMap.set(this, this.mInnerOnTrackChangedListener);
        onSnapShotListenerMap.set(this, this.mInnerOnSnapShotListener);
        onSeiDataListenerMap.set(this, this.mInnerOnSeiDataListener);
        onUrlExpiredListenerMap.set(this, this.mInnerOnUrlExpiredListener);
        this.bindListener();
    }
    getNativeContextAddr() {
        return this.mCorePlayer?.getNativeContextAddr();
    }
    prepare() {
        this.prepareInner();
    }
    prepareInner() {
        this.mCorePlayer?.prepare();
    }
    getCorePlayer() {
        return this.mCorePlayer;
    }
    start() {
        this.startInner();
    }
    startInner() {
        this.mCorePlayer?.start();
    }
    pause() {
        this.pauseInner();
    }
    pauseInner() {
        this.mCorePlayer?.pause();
    }
    stop() {
        let c19 = "protected.playEvent.user.stop";
        this.setGlobalTime(c19);
        this.stopInner();
    }
    stopInner() {
        this.mCorePlayer?.stop();
    }
    setAutoPlay(b19) {
        this.mCorePlayer?.setAutoPlay(b19);
    }
    setSurfaceId(a19) {
        this.mCorePlayer?.setSurfaceId(a19);
    }
    setSpeed(z18) {
        this.mCorePlayer?.setSpeed(z18);
    }
    setVolume(y18) {
        this.mCorePlayer?.setVolume(y18);
    }
    getVolume() {
        return this.mCorePlayer?.getVolume();
    }
    seekTo(w18, x18) {
        this.mCorePlayer?.seekTo(w18, x18);
    }
    setStartTime(u18, v18) {
        this.mCorePlayer?.setStartTime(u18, v18);
    }
    getDuration() {
        return this.mCorePlayer?.getDuration();
    }
    getPlayedDuration() {
        return this.mCorePlayer?.getPlayedDuration();
    }
    getCurrentPosition() {
        return this.mCorePlayer?.getCurrentPosition();
    }
    getBufferedPosition() {
        return this.mCorePlayer?.getBufferedPosition();
    }
    getPlayerStatus() {
        return this.mCorePlayer?.getPlayerStatus();
    }
    enableHardwareDecoder(t18) {
        this.mCorePlayer?.enableHardwareDecoder(t18);
    }
    release() {
        let s18 = "protected.playEvent.user.destroy";
        this.setGlobalTime(s18);
        this.releaseInner();
    }
    setGlobalTime(r18) {
        this.mCorePlayer?.setGlobalTime(r18);
    }
    releaseInner() {
        this.mCorePlayer?.release();
    }
    releaseAsync() {
        let p18 = "protected.playEvent.user.destroy";
        this.setGlobalTime(p18);
        log.info('releaseAsync');
        this.pause();
        setTimeout(() => {
            this.stopInner();
            this.releaseInner();
        }, 0);
    }
    setMute(o18) {
        this.mCorePlayer?.setMute(o18);
    }
    isMuted() {
        return this.mCorePlayer?.isMuted();
    }
    setScaleMode(n18) {
        this.mCorePlayer?.setScaleMode(n18);
    }
    getScaleMode() {
        return this.mCorePlayer?.getScaleMode();
    }
    setLoop(m18) {
        this.mCorePlayer?.setLoop(m18);
    }
    isLoop() {
        return this.mCorePlayer?.isLoop();
    }
    getVideoWidth() {
        return this.mCorePlayer?.getVideoWidth();
    }
    getVideoHeight() {
        return this.mCorePlayer?.getVideoHeight();
    }
    getVideoRotation() {
        return this.mCorePlayer?.getVideoRotation();
    }
    reload() {
        this.mCorePlayer?.reload();
    }
    setRotateMode(l18) {
        this.mCorePlayer?.setRotateMode(l18);
    }
    getRotateMode() {
        return this.mCorePlayer?.getRotateMode();
    }
    setMirrorMode(k18) {
        this.mCorePlayer?.setMirrorMode(k18);
    }
    getMirrorMode() {
        return this.mCorePlayer?.getMirrorMode();
    }
    setAlphaRenderMode(j18) {
        this.mCorePlayer?.setAlphaRenderMode(j18);
    }
    getAlphaRenderMode() {
        return this.mCorePlayer?.getAlphaRenderMode();
    }
    setVideoBackgroundColor(i18) {
        this.mCorePlayer?.setVideoBackgroundColor(i18);
    }
    getSpeed() {
        return this.mCorePlayer?.getSpeed();
    }
    isAutoPlay() {
        return this.mCorePlayer?.isAutoPlay();
    }
    setConfig(h18) {
        this.mCorePlayer?.setConfig(h18);
    }
    getConfig() {
        return this.mCorePlayer?.getConfig();
    }
    setPlayerScene(g18) {
        this.mCorePlayer?.setPlayerScene(g18);
    }
    setOption(d18, e18) {
        let f18 = "player_option_" + d18 + "_str";
        this.mCorePlayer?.setOption(f18, e18);
    }
    setOptionNum(a18, b18) {
        let c18 = "player_option_" + a18.toString() + "_str";
        this.mCorePlayer?.setOption(c18, b18.toString());
    }
    getOption(z17) {
        return this.mCorePlayer?.getOption(z17);
    }
    selectTrack(y17) {
        this.mCorePlayer?.selectTrack(y17);
    }
    switchStream(x17) {
        this.mCorePlayer?.switchStream(x17);
    }
    getMediaInfo() {
        return this.mOutMediaInfo;
    }
    getSubMediaInfo() {
        return this.mOutSubMediaInfo;
    }
    currentTrack(w17) {
        if (this.mCorePlayer) {
            return this.mCorePlayer.getCurrentTrack(w17);
        }
        else {
            return null;
        }
    }
    addExtSubtitle(v17) {
        this.mCorePlayer?.addExtSubtitle(v17);
    }
    ;
    selectExtSubtitle(t17, u17) {
        this.mCorePlayer?.selectExtSubtitle(t17, u17);
    }
    setStreamDelay(r17, s17) {
        this.mCorePlayer?.setStreamDelay(r17, s17);
    }
    setMaxAccurateSeekDelta(q17) {
        this.mCorePlayer?.setMaxAccurateSeekDelta(q17);
    }
    setCacheConfig(p17) {
        this.mCorePlayer?.setCacheConfig(p17);
    }
    setIPResolveType(o17) {
        this.mCorePlayer?.setIPResolveType(o17);
    }
    setFastStart(n17) {
        this.mCorePlayer?.setFastStart(n17);
    }
    snapShot() {
        this.mCorePlayer?.snapShot();
    }
    clearScreen() {
        this.mCorePlayer?.clearScreen();
    }
    getCacheFilePathByUrl(m17) {
        return this.mCorePlayer?.getCacheFilePathByUrl(m17) ?? '';
    }
    getCacheFilePathByVid(i17, j17, k17, l17) {
        return this.mCorePlayer?.getCacheFilePathByVid(i17, j17, k17, l17) ?? '';
    }
    getPropertyString(h17) {
        return this.mCorePlayer?.getPropertyString(h17) ?? '';
    }
    setDefaultBandWidth(g17) {
        this.mCorePlayer?.setDefaultBandWidth(g17);
    }
    setDefaultResolution(f17) {
        this.mCorePlayer?.setDefaultResolution(f17);
    }
    setAutoBandWidth(e17) {
        this.mCorePlayer?.setAutoBandWidth(e17);
    }
    isAutoBandWidth() {
        return this.mCorePlayer?.isAutoBandWidth() ?? false;
    }
    sendCustomEvent(d17) {
        this.mCorePlayer?.sendCustomEvent(d17);
    }
    setVideoTag(c17) {
        this.mCorePlayer?.setVideoTag(c17);
    }
    setUserData(b17) {
        this.mCorePlayer?.setUserData(b17);
    }
    setTraceId(a17) {
        this.mCorePlayer?.setTraceId(a17);
    }
    getUserData() {
        return this.mCorePlayer?.getUserData() ?? '';
    }
    refreshPlayerUrl(z16) {
        this.mCorePlayer?.refreshPlayerUrl(z16);
    }
    refreshPlayerUrlWithError(y16) {
        this.mCorePlayer?.refreshPlayerUrlWithError(y16);
    }
    bindListener() {
        this.mCorePlayer?.setOnPreparedListener(this.mInnerOnPreparedListener);
        this.mCorePlayer?.setOnInfoListener(this.mInnerOnInfoListener);
        this.mCorePlayer?.setOnRenderingStartListener(this.mInnerOnRenderingStartListener);
        this.mCorePlayer?.setOnStateChangedListener(this.mInnerOnStateChangedListener);
        this.mCorePlayer?.setOnVideoSizeChangedListener(this.mInnerOnVideoSizeChangedListener);
        this.mCorePlayer?.setOnLoadingStatusListener(this.mInnerOnLoadingStatusListener);
        this.mCorePlayer?.setOnSeekCompleteListener(this.mInnerOnSeekCompleteListener);
        this.mCorePlayer?.setOnCompletionListener(this.mInnerOnCompletionListener);
        this.mCorePlayer?.setOnVideoRenderedListener(this.mInnerOnVideoRenderedListener);
        this.mCorePlayer?.setOnSubtitleDisplayListener(this.mInnerOnSubtitleDisplayListener);
        this.mCorePlayer?.setOnErrorListener(this.mInnerOnErrorListener);
        this.mCorePlayer?.setOnAudioInterruptEventListener(this.mInnerOnAudioInterruptEventListener);
        this.mCorePlayer?.setOnTrackReadyListener(this.mInnerOnTrackReadyListener);
        this.mCorePlayer?.setOnSubTrackReadyListener(this.mInnerOnSubTrackReadyListener);
        this.mCorePlayer?.setOnStreamSwitchedListener(this.mInnerOnStreamSwitchedListener);
        this.mCorePlayer?.setOnAVNotSyncStatusListener(this.mInnerOnAVNotSyncStatusListener);
        this.mCorePlayer?.setOnNetworkStatsListener(this.mInnerOnNetworkStatsListener);
        this.mCorePlayer?.setOnTrackChangedListener(this.mInnerOnTrackChangedListener);
        this.mCorePlayer?.setOnSnapShotListener(this.mInnerOnSnapShotListener);
        this.mCorePlayer?.setOnSeiDataListener(this.mInnerOnSeiDataListener);
        this.mCorePlayer?.setOnUrlExpiredListener(this.mInnerOnUrlExpiredListener);
        this.mCorePlayer?.setHasListenerCallback(this.mInnerHasListenerCallback);
    }
    setOnPreparedListener(x16) {
        this.mOutOnPreparedListener = x16;
    }
    setOnInfoListener(w16) {
        this.mOutOnInfoListener = w16;
    }
    setOnRenderingStartListener(v16) {
        this.mOutOnRenderingStartListener = v16;
    }
    setOnStateChangedListener(u16) {
        this.mOutOnStateChangedListener = u16;
    }
    setOnCompletionListener(t16) {
        this.mOutOnCompletionListener = t16;
    }
    setOnAVNotSyncStatusListener(s16) {
        this.mOutOnAVNotSyncStatusListener = s16;
    }
    setOnNetworkStatsListener(r16) {
        this.mOutOnNetworkStatsListener = r16;
    }
    setOnStreamSwitchedListener(q16) {
        this.mOutOnStreamSwitchedListener = q16;
    }
    setOnLoadingStatusListener(p16) {
        this.mOutOnLoadingStatusListener = p16;
    }
    setOnErrorListener(o16) {
        this.mOutOnErrorListener = o16;
    }
    setOnVideoSizeChangedListener(n16) {
        this.mOutOnVideoSizeChangedListener = n16;
    }
    setOnSeekCompleteListener(m16) {
        this.mOutOnSeekCompleteListener = m16;
    }
    setOnSubtitleDisplayListener(l16) {
        this.mOutOnSubtitleDisplayListener = l16;
    }
    setOnVideoRenderedListener(k16) {
        this.mOutOnVideoRenderedListener = k16;
    }
    setOnAudioInterruptEventListener(j16) {
        this.mOutOnAudioInterruptEventListener = j16;
    }
    setOnTrackReadyListener(i16) {
        this.mOutOnTrackReadyListener = i16;
    }
    setOnSubTrackReadyListener(h16) {
        this.mOutOnSubTrackReadyListener = h16;
    }
    setOnTrackChangedListener(g16) {
        this.mOutOnTrackChangedListener = g16;
    }
    setOnSnapShotListener(f16) {
        this.mOutOnSnapShotListener = f16;
    }
    setOnSeiDataListener(e16) {
        this.mOutOnSeiDataListener = e16;
    }
    setOnUrlExpiredListener(d16) {
        this.mOutOnUrlExpiredListener = d16;
    }
    onPrepared() {
        if (this.mOutOnPreparedListener != null) {
            this.mOutOnPreparedListener.onPrepared();
        }
    }
    onInfo(c16) {
        if (this.mOutOnInfoListener != null) {
            this.mOutOnInfoListener.onInfo(c16);
        }
    }
    onRenderingStart() {
        if (this.mOutOnRenderingStartListener != null) {
            this.mOutOnRenderingStartListener.onRenderingStart();
        }
    }
    onStateChanged(b16) {
        if (this.mOutOnStateChangedListener != null) {
            this.mOutOnStateChangedListener.onStateChanged(b16);
        }
    }
    onVideoSizeChanged(z15, a16) {
        if (this.mOutOnVideoSizeChangedListener != null) {
            this.mOutOnVideoSizeChangedListener.onVideoSizeChanged(z15, a16);
        }
    }
    onLoadingBegin() {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingBegin();
        }
    }
    onLoadingProgress(x15, y15) {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingProgress(x15, y15);
        }
    }
    onLoadingEnd() {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingEnd();
        }
    }
    onSeekEnd() {
        if (this.mOutOnSeekCompleteListener != null) {
            this.mOutOnSeekCompleteListener.onSeekComplete();
        }
    }
    onCompletion() {
        if (this.mOutOnCompletionListener != null) {
            this.mOutOnCompletionListener.onCompletion();
        }
    }
    onVideoRendered(v15, w15) {
        if (this.mOutOnVideoRenderedListener != null) {
            this.mOutOnVideoRenderedListener.onVideoRendered(v15, w15);
        }
    }
    onSubtitleShow(s15, t15, u15) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleShow(s15, t15, u15);
        }
    }
    onSubtitleExtAdded(q15, r15) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleExtAdded(q15, r15);
        }
    }
    onSubtitleHide(o15, p15) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleHide(o15, p15);
        }
    }
    onSubtitleHeader(m15, n15) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleHeader(m15, n15);
        }
    }
    onError(l15) {
        if (this.mOutOnErrorListener != null) {
            this.mOutOnErrorListener.onError(l15);
        }
    }
    onAudioInterruptEvent(k15) {
        if (this.mOutOnAudioInterruptEventListener != null) {
            this.mOutOnAudioInterruptEventListener.onAudioInterruptEvent(k15);
        }
    }
    onTrackReady(j15) {
        this.mOutMediaInfo = j15;
        if (this.mOutOnTrackReadyListener != null) {
            this.mOutOnTrackReadyListener.onTrackReady(j15);
        }
    }
    onSubTrackReady(i15) {
        this.mOutSubMediaInfo = i15;
        if (this.mOutOnSubTrackReadyListener != null) {
            this.mOutOnSubTrackReadyListener.onSubTrackReady(i15);
        }
    }
    onSwitchedSuccess(h15) {
        if (this.mOutOnStreamSwitchedListener != null) {
            this.mOutOnStreamSwitchedListener.onSwitchedSuccess(h15);
        }
    }
    onSwitchedFail(f15, g15) {
        if (this.mOutOnStreamSwitchedListener != null) {
            this.mOutOnStreamSwitchedListener.onSwitchedFail(f15, g15);
        }
    }
    onAVNotSyncStart(e15) {
        if (this.mOutOnAVNotSyncStatusListener != null) {
            this.mOutOnAVNotSyncStatusListener.onAVNotSyncStart(e15);
        }
    }
    onAVNotSyncEnd() {
        if (this.mOutOnAVNotSyncStatusListener != null) {
            this.mOutOnAVNotSyncStatusListener.onAVNotSyncEnd();
        }
    }
    onNetworkStats(d15) {
        if (this.mOutOnNetworkStatsListener != null) {
            this.mOutOnNetworkStatsListener.onNetworkStats(d15);
        }
    }
    onChangedSuccess(c15) {
        if (this.mOutOnTrackChangedListener != null) {
            this.mOutOnTrackChangedListener.onChangedSuccess(c15);
        }
    }
    onSnapShot(z14, a15, b15) {
        if (this.mOutOnSnapShotListener != null) {
            this.mOutOnSnapShotListener.onSnapShot(z14, a15, b15);
        }
    }
    onSeiData(x14, y14) {
        if (this.mOutOnSeiDataListener != null) {
            this.mOutOnSeiDataListener.onSeiData(x14, y14);
        }
    }
    onUrlExpired(u14, v14) {
        if (this.mOutOnUrlExpiredListener != null) {
            const w14 = new UrlRefreshCallbackImpl(this);
            this.mOutOnUrlExpiredListener.onUrlExpired(u14, w14);
        }
    }
}
class InnerPrepareListener {
    constructor(t14) {
        this.avbBaseWR = t14;
    }
    onPrepared() {
        if (this.avbBaseWR != null) {
            this.avbBaseWR.onPrepared();
        }
    }
}
class InnerInfoListener {
    constructor(s14) {
        this.avpBaseRef = s14;
    }
    onInfo(r14) {
        if (this.avpBaseRef != null) {
            this.avpBaseRef.onInfo(r14);
        }
    }
}
class InnerRenderingStartListener {
    constructor(q14) {
        this.avpBaseRef = q14;
    }
    onRenderingStart() {
        if (this.avpBaseRef != null) {
            this.avpBaseRef.onRenderingStart();
        }
    }
}
class InnerStateChangedListener {
    constructor(p14) {
        this.avpBaseRef = p14;
    }
    onStateChanged(o14) {
        this.avpBaseRef.onStateChanged(o14);
    }
}
class InnerVideoSizeChangedListener {
    constructor(n14) {
        this.avpBaseRef = n14;
    }
    onVideoSizeChanged(l14, m14) {
        this.avpBaseRef.onVideoSizeChanged(l14, m14);
    }
}
class InnerLoadingStatusListener {
    constructor(k14) {
        this.avpBaseRef = k14;
    }
    onLoadingBegin() {
        this.avpBaseRef.onLoadingBegin();
    }
    onLoadingProgress(i14, j14) {
        this.avpBaseRef.onLoadingProgress(i14, j14);
    }
    onLoadingEnd() {
        this.avpBaseRef.onLoadingEnd();
    }
}
class InnerSeekCompleteListener {
    constructor(h14) {
        this.avpBaseRef = h14;
    }
    onSeekComplete() {
        this.avpBaseRef.onSeekEnd();
    }
}
class InnerCompletionListener {
    constructor(g14) {
        this.avpBaseRef = g14;
    }
    onCompletion() {
        this.avpBaseRef.onCompletion();
    }
}
class InnerVideoRenderedListener {
    constructor(f14) {
        this.avpBaseRef = f14;
    }
    onVideoRendered(d14, e14) {
        this.avpBaseRef.onVideoRendered(d14, e14);
    }
}
class InnerSubtitleDisplayListener {
    constructor(c14) {
        this.avpBaseRef = c14;
    }
    onSubtitleShow(z13, a14, b14) {
        this.avpBaseRef.onSubtitleShow(z13, a14, b14);
    }
    onSubtitleExtAdded(x13, y13) {
        this.avpBaseRef.onSubtitleExtAdded(x13, y13);
    }
    onSubtitleHide(v13, w13) {
        this.avpBaseRef.onSubtitleHide(v13, w13);
    }
    onSubtitleHeader(t13, u13) {
        this.avpBaseRef.onSubtitleHeader(t13, u13);
    }
}
class InnerErrorListener {
    constructor(s13) {
        this.avpBaseRef = s13;
    }
    onError(r13) {
        this.avpBaseRef.onError(r13);
    }
}
class InnerAudioInterruptEventListener {
    constructor(q13) {
        this.avpBaseRef = q13;
    }
    onAudioInterruptEvent(p13) {
        this.avpBaseRef.onAudioInterruptEvent(p13);
    }
}
class InnerTrackReadyListener {
    constructor(o13) {
        this.avpBaseRef = o13;
    }
    onTrackReady(n13) {
        this.avpBaseRef.onTrackReady(n13);
    }
}
class InnerSubTrackReadyListener {
    constructor(m13) {
        this.avpBaseRef = m13;
    }
    onSubTrackReady(l13) {
        this.avpBaseRef.onSubTrackReady(l13);
    }
}
class InnerStreamSwitchedListener {
    constructor(k13) {
        this.avpBaseRef = k13;
    }
    onSwitchedSuccess(j13) {
        this.avpBaseRef.onSwitchedSuccess(j13);
    }
    onSwitchedFail(h13, i13) {
        this.avpBaseRef.onSwitchedFail(h13, i13);
    }
}
class InnerOnAVNotSyncStatusListener {
    constructor(g13) {
        this.avpBaseRef = g13;
    }
    onAVNotSyncStart(f13) {
        this.avpBaseRef.onAVNotSyncStart(f13);
    }
    onAVNotSyncEnd() {
        this.avpBaseRef.onAVNotSyncEnd();
    }
}
class InnerOnNetworkStatsListener {
    constructor(e13) {
        this.avpBaseRef = e13;
    }
    onNetworkStats(d13) {
        this.avpBaseRef.onNetworkStats(d13);
    }
}
class InnerTrackChangedListener {
    constructor(c13) {
        this.avpBaseRef = c13;
    }
    onChangedSuccess(b13) {
        this.avpBaseRef.onChangedSuccess(b13);
    }
}
class InnerSnapShotListener {
    constructor(a13) {
        this.avpBaseRef = a13;
    }
    onSnapShot(x12, y12, z12) {
        this.avpBaseRef.onSnapShot(x12, y12, z12);
    }
}
class InnerSeiDataListener {
    constructor(w12) {
        this.avpBaseRef = w12;
    }
    onSeiData(u12, v12) {
        this.avpBaseRef.onSeiData(u12, v12);
    }
}
class InnerUrlExpiredListener {
    constructor(t12) {
        this.avpBaseRef = t12;
    }
    onUrlExpired(r12, s12) {
        this.avpBaseRef.onUrlExpired(r12, s12);
    }
}
class InnerHasListenerCallback {
    constructor(q12) {
        this.avpBase = q12;
    }
    hasListener(p12) {
        if (this.avpBase == null) {
            return false;
        }
        switch (p12) {
            case 0:
                return this.avpBase.mOutOnUrlExpiredListener != null;
            default:
                return false;
        }
    }
}
class UrlRefreshCallbackImpl {
    constructor(o12) {
        this.avpBase = o12;
    }
    onSuccess(n12) {
        this.avpBase.refreshPlayerUrl(n12.url);
    }
    onError(m12) {
        this.avpBase.refreshPlayerUrlWithError(m12);
    }
}
