export var PreloadOptionType;
(function (w36) {
    w36["RESOLUTION"] = "RESOLUTION";
    w36["BANDWIDTH"] = "BANDWIDTH";
    w36["QUALITY"] = "QUALITY";
    w36["NONE"] = "NONE";
})(PreloadOptionType || (PreloadOptionType = {}));
export class PreloadConfig {
    constructor(k36) {
        this.mPreloadDuration = 1000;
        this.mNetworkTimeout = 15000;
        this.mNetworkRetryCount = 2;
        this.mReferrer = '';
        this.mCustomHeaders = [];
        this.mOptionType = PreloadOptionType.NONE;
        this.mOptionIntValue = 0;
        this.mOptionStringValue = '';
        this.nativeGetDefaultBandWidth = () => {
            let v36 = this.getDefaultBandWidth();
            return v36;
        };
        this.nativeGetDefaultResolution = () => {
            return this.getDefaultResolution();
        };
        this.nativeGetDefaultQuality = () => {
            return this.getDefaultQuality();
        };
        this.nativeGetDefaultType = () => {
            return this.getDefaultType().toString();
        };
        this.nativeGetDuration = () => {
            let u36 = this.getDuration();
            return this.getDuration();
        };
        this.nativeGetNetworkTimeout = () => {
            return this.getNetworkTimeout();
        };
        this.nativeGetNetworkRetryCount = () => {
            return this.getNetworkRetryCount();
        };
        this.nativeGetReferrer = () => {
            return this.getReferrer();
        };
        this.nativeGetCustomHeaders = () => {
            return this.getCustomHeaders();
        };
        if (k36 !== undefined) {
            this.mPreloadDuration = k36;
        }
    }
    getDuration() {
        return this.mPreloadDuration;
    }
    setDuration(j36) {
        this.mPreloadDuration = j36;
    }
    getNetworkTimeout() {
        return this.mNetworkTimeout;
    }
    setNetworkTimeout(i36) {
        this.mNetworkTimeout = i36;
    }
    getNetworkRetryCount() {
        return this.mNetworkRetryCount;
    }
    setNetworkRetryCount(h36) {
        this.mNetworkRetryCount = h36;
    }
    getReferrer() {
        return this.mReferrer;
    }
    setReferrer(g36) {
        this.mReferrer = g36;
    }
    getCustomHeaders() {
        return this.mCustomHeaders;
    }
    setCustomHeaders(f36) {
        this.mCustomHeaders = f36;
    }
    setDefaultResolution(e36) {
        this.mOptionType = PreloadOptionType.RESOLUTION;
        this.mOptionIntValue = e36;
        this.mOptionStringValue = '';
    }
    getDefaultResolution() {
        return (this.mOptionType === PreloadOptionType.RESOLUTION) ? this.mOptionIntValue : 0;
    }
    setDefaultBandWidth(d36) {
        this.mOptionType = PreloadOptionType.BANDWIDTH;
        this.mOptionIntValue = d36;
        this.mOptionStringValue = '';
    }
    getDefaultBandWidth() {
        return (this.mOptionType === PreloadOptionType.BANDWIDTH) ? this.mOptionIntValue : 0;
    }
    setDefaultQuality(c36) {
        this.mOptionType = PreloadOptionType.QUALITY;
        this.mOptionStringValue = c36;
        this.mOptionIntValue = 0;
    }
    getDefaultQuality() {
        return (this.mOptionType === PreloadOptionType.QUALITY) ? this.mOptionStringValue : '';
    }
    getDefaultType() {
        return this.mOptionType;
    }
}
