import { ALLOW_PRE_RENDER } from './IPlayer';
export class AVPLBase {
    constructor(j22, k22) {
        this.mNativePlayer = this.getNativePlayerWithContext(j22, k22);
        this.mPreRenderPlayer = this.getPrerenderPlayerWithContext(j22, k22);
        this.mListPlayer = this.createListPlayer(j22, k22, this.mNativePlayer.getNativeContextAddr(), this.mPreRenderPlayer.getNativeContextAddr());
    }
    getCurrentPlayer() {
        let i22 = this.getCurrentPlayerIndex();
        if (i22 == 1) {
            return this.mPreRenderPlayer;
        }
        else {
            return this.mNativePlayer;
        }
    }
    getCurrentPrerenderPlayer(h22) {
        if (h22 == 0) {
            return this.mNativePlayer;
        }
        else if (h22 == 1) {
            return this.mPreRenderPlayer;
        }
        return undefined;
    }
    getCorePlayer() {
        return this.mListPlayer;
    }
    getNativePlayer() {
        return this.mNativePlayer;
    }
    getPrerenderPlayer() {
        return this.mPreRenderPlayer;
    }
    removeSource(g22) {
        this.mListPlayer?.removeSource(g22);
    }
    clear() {
        this.mListPlayer?.clear();
    }
    getCurrentUid() {
        return this.mListPlayer?.getCurrentUid();
    }
    setMaxPreloadMemorySizeMB(f22) {
        this.mListPlayer?.setMaxPreloadMemorySizeMB(f22);
    }
    getMaxPreloadMemorySizeMB() {
        return this.mListPlayer?.getMaxPreloadMemorySizeMB();
    }
    SetMultiBitratesMode(e22) {
        this.mListPlayer?.SetMultiBitratesMode(e22);
    }
    GetMultiBitratesMode() {
        return this.mListPlayer?.GetMultiBitratesMode();
    }
    setPreloadCount(d22) {
        this.mListPlayer?.setPreloadCount(d22);
    }
    setPreloadScene(c22) {
        this.mListPlayer?.setPreloadScene(c22);
    }
    enablePreloadStrategy(a22, b22) {
        this.mListPlayer?.enablePreloadStrategy(a22, b22);
    }
    setPreloadStrategy(y21, z21) {
        this.mListPlayer?.setPreloadStrategyParam(y21, z21);
    }
    setPreloadCountWithPrevAndNext(w21, x21) {
        this.mListPlayer?.setPreloadCountWithPrevAndNext(w21, x21);
    }
    getNativeContextAddr() {
        return this.getCurrentPlayer()?.getNativeContextAddr();
    }
    prepare() {
        this.getCurrentPlayer().prepare();
    }
    start() {
        this.getCurrentPlayer()?.start();
    }
    pause() {
        this.getCurrentPlayer().pause();
    }
    stop() {
        this.getCurrentPlayer().stop();
    }
    setAutoPlay(v21) {
        this.getCurrentPlayer().setAutoPlay(v21);
    }
    setSurfaceId(u21) {
        this.getCurrentPlayer().setSurfaceId(u21);
    }
    setSpeed(t21) {
        this.getCurrentPlayer().setSpeed(t21);
    }
    setVolume(s21) {
        this.getCurrentPlayer().setVolume(s21);
    }
    getVolume() {
        return this.getCurrentPlayer().getVolume();
    }
    seekTo(q21, r21) {
        this.getCurrentPlayer().seekTo(q21, r21);
    }
    setStartTime(o21, p21) {
        this.getCurrentPlayer().setStartTime(o21, p21);
    }
    getDuration() {
        return this.getCurrentPlayer().getDuration();
    }
    getPlayedDuration() {
        return this.getCurrentPlayer().getPlayedDuration();
    }
    getCurrentPosition() {
        return this.getCurrentPlayer().getCurrentPosition();
    }
    getBufferedPosition() {
        return this.getCurrentPlayer().getBufferedPosition();
    }
    getPlayerStatus() {
        return this.getCurrentPlayer().getPlayerStatus();
    }
    enableHardwareDecoder(n21) {
        this.getCurrentPlayer().enableHardwareDecoder(n21);
    }
    release() {
        this.mListPlayer?.release();
        this.mNativePlayer?.release();
        this.mPreRenderPlayer?.release();
    }
    releaseAsync() {
        this.release();
    }
    setMute(m21) {
        this.getCurrentPlayer().setMute(m21);
    }
    isMuted() {
        return this.getCurrentPlayer().isMuted();
    }
    setScaleMode(l21) {
        this.getCurrentPlayer().setScaleMode(l21);
    }
    getScaleMode() {
        return this.getCurrentPlayer().getScaleMode();
    }
    setLoop(k21) {
        this.getCurrentPlayer().setLoop(k21);
    }
    isLoop() {
        return this.getCurrentPlayer().isLoop();
    }
    getVideoWidth() {
        return this.getCurrentPlayer().getVideoWidth();
    }
    getVideoHeight() {
        return this.getCurrentPlayer().getVideoHeight();
    }
    getVideoRotation() {
        return this.getCurrentPlayer().getVideoRotation();
    }
    reload() {
        this.getCurrentPlayer().reload();
    }
    setRotateMode(j21) {
        this.getCurrentPlayer().setRotateMode(j21);
    }
    getRotateMode() {
        return this.getCurrentPlayer().getRotateMode();
    }
    setMirrorMode(i21) {
        this.getCurrentPlayer().setMirrorMode(i21);
    }
    getMirrorMode() {
        return this.getCurrentPlayer().getMirrorMode();
    }
    setAlphaRenderMode(h21) {
        this.getCurrentPlayer().setAlphaRenderMode(h21);
    }
    getAlphaRenderMode() {
        return this.getCurrentPlayer().getAlphaRenderMode();
    }
    setVideoBackgroundColor(g21) {
        this.getCurrentPlayer().setVideoBackgroundColor(g21);
    }
    getSpeed() {
        return this.getCurrentPlayer().getSpeed();
    }
    isAutoPlay() {
        return this.getCurrentPlayer().isAutoPlay();
    }
    setConfig(f21) {
        if (this.mNativePlayer != null) {
            this.mNativePlayer.setConfig(f21);
        }
        if (this.mPreRenderPlayer != null) {
            this.mPreRenderPlayer.setConfig(f21);
        }
    }
    getConfig() {
        return this.getCurrentPlayer().getConfig();
    }
    setPlayerScene(e21) {
        this.getCurrentPlayer().setPlayerScene(e21);
    }
    setOption(c21, d21) {
        this.getCurrentPlayer().setOption(c21, d21);
    }
    setOptionNum(a21, b21) {
        this.getCurrentPlayer().setOptionNum(a21, b21);
        if (a21 == ALLOW_PRE_RENDER) {
            if (this.getCurrentPlayer() == this.mPreRenderPlayer) {
                this.mNativePlayer?.setOptionNum(a21, b21);
            }
            else {
                this.mPreRenderPlayer?.setOptionNum(a21, b21);
            }
        }
    }
    getOption(z20) {
        return this.getCurrentPlayer().getOption(z20);
    }
    selectTrack(y20) {
        this.getCurrentPlayer()?.selectTrack(y20);
    }
    switchStream(x20) {
        this.getCurrentPlayer()?.switchStream(x20);
    }
    getMediaInfo() {
        return this.getCurrentPlayer()?.getMediaInfo();
    }
    getSubMediaInfo() {
        return this.getCurrentPlayer()?.getSubMediaInfo();
    }
    currentTrack(w20) {
        return this.getCurrentPlayer()?.currentTrack(w20);
    }
    addExtSubtitle(v20) {
        this.getCurrentPlayer()?.addExtSubtitle(v20);
    }
    selectExtSubtitle(t20, u20) {
        this.getCurrentPlayer()?.selectExtSubtitle(t20, u20);
    }
    setStreamDelay(r20, s20) {
        this.getCurrentPlayer()?.setStreamDelay(r20, s20);
    }
    setMaxAccurateSeekDelta(q20) {
        this.getCurrentPlayer()?.setMaxAccurateSeekDelta(q20);
    }
    setCacheConfig(p20) {
        this.getCurrentPlayer()?.setCacheConfig(p20);
    }
    setIPResolveType(o20) {
        this.getCurrentPlayer()?.setIPResolveType(o20);
    }
    setFastStart(n20) {
        this.getCurrentPlayer()?.setFastStart(n20);
    }
    snapShot() {
        this.getCurrentPlayer()?.snapShot();
    }
    clearScreen() {
        this.getCurrentPlayer()?.clearScreen();
    }
    getCacheFilePathByUrl(m20) {
        return this.getCurrentPlayer()?.getCacheFilePathByUrl(m20) || '';
    }
    getCacheFilePathByVid(i20, j20, k20, l20) {
        return this.getCurrentPlayer()?.getCacheFilePathByVid(i20, j20, k20, l20) || '';
    }
    getPropertyString(h20) {
        return this.getCurrentPlayer()?.getPropertyString(h20) || '';
    }
    setDefaultBandWidth(g20) {
        this.getCurrentPlayer()?.setDefaultBandWidth(g20);
    }
    setDefaultResolution(f20) {
        this.getCurrentPlayer()?.setDefaultResolution(f20);
    }
    setAutoBandWidth(e20) {
        this.getCurrentPlayer()?.setAutoBandWidth(e20);
    }
    isAutoBandWidth() {
        return this.getCurrentPlayer()?.isAutoBandWidth() ?? false;
    }
    sendCustomEvent(d20) {
        this.getCurrentPlayer()?.sendCustomEvent(d20);
    }
    setVideoTag(c20) {
        this.getCurrentPlayer()?.setVideoTag(c20);
    }
    setUserData(b20) {
        this.getCurrentPlayer()?.setUserData(b20);
    }
    setTraceId(a20) {
        this.getCurrentPlayer()?.setTraceId(a20);
    }
    getUserData() {
        return this.getCurrentPlayer()?.getUserData() || '';
    }
    setOnPreparedListener(z19) {
        this.getCurrentPlayer().setOnPreparedListener(z19);
    }
    setOnInfoListener(y19) {
        this.getCurrentPlayer().setOnInfoListener(y19);
    }
    setOnRenderingStartListener(x19) {
        this.getCurrentPlayer().setOnRenderingStartListener(x19);
    }
    setOnStateChangedListener(w19) {
        this.getCurrentPlayer().setOnStateChangedListener(w19);
    }
    setOnCompletionListener(v19) {
        this.getCurrentPlayer().setOnCompletionListener(v19);
    }
    setOnLoadingStatusListener(u19) {
        this.getCurrentPlayer().setOnLoadingStatusListener(u19);
    }
    setOnAVNotSyncStatusListener(t19) {
        this.getCurrentPlayer()?.setOnAVNotSyncStatusListener(t19);
    }
    setOnNetworkStatsListener(s19) {
        this.getCurrentPlayer()?.setOnNetworkStatsListener(s19);
    }
    setOnErrorListener(r19) {
        this.getCurrentPlayer().setOnErrorListener(r19);
    }
    setOnVideoSizeChangedListener(q19) {
        this.getCurrentPlayer().setOnVideoSizeChangedListener(q19);
    }
    setOnSeekCompleteListener(p19) {
        this.getCurrentPlayer().setOnSeekCompleteListener(p19);
    }
    setOnSubtitleDisplayListener(o19) {
        this.getCurrentPlayer().setOnSubtitleDisplayListener(o19);
    }
    setOnVideoRenderedListener(n19) {
        this.getCurrentPlayer().setOnVideoRenderedListener(n19);
    }
    setOnAudioInterruptEventListener(m19) {
        this.getCurrentPlayer().setOnAudioInterruptEventListener(m19);
    }
    setOnSubTrackReadyListener(l19) {
        this.getCurrentPlayer()?.setOnSubTrackReadyListener(l19);
    }
    setOnTrackReadyListener(k19) {
        this.getCurrentPlayer()?.setOnTrackReadyListener(k19);
    }
    setOnTrackChangedListener(j19) {
        this.getCurrentPlayer()?.setOnTrackChangedListener(j19);
    }
    setOnSnapShotListener(i19) {
        this.getCurrentPlayer()?.setOnSnapShotListener(i19);
    }
    setOnSeiDataListener(h19) {
        this.getCurrentPlayer()?.setOnSeiDataListener(h19);
    }
    setOnStreamSwitchedListener(g19) {
        this.getCurrentPlayer()?.setOnStreamSwitchedListener(g19);
    }
    setOnUrlExpiredListener(f19) {
        this.getCurrentPlayer()?.setOnUrlExpiredListener(f19);
    }
}
