import premierlibrary from 'libpremierlibrary.so';
export class HlsKeyGenerator {
    static getInstance() {
        if (HlsKeyGenerator.instance == undefined) {
            HlsKeyGenerator.instance = new HlsKeyGenerator();
        }
        return HlsKeyGenerator.instance;
    }
    static setOnKeyGenerateListener(o23) {
        HlsKeyGenerator.getInstance().mOnKeyGenerateListener = o23;
    }
    constructor() {
        this.mOutKey = "default-key";
        this.getHlsOutKey = () => {
            return HlsKeyGenerator.getInstance().mOutKey;
        };
        this.onHlsKeyInfoInit = (l23, m23, n23) => {
            console.log('onHlsKeyInfoInit called.');
            if (this.mOnKeyGenerateListener != null) {
                this.mOnKeyGenerateListener.onHlsKeyInfoInit(l23, m23, n23);
            }
        };
        this.getHlsKey = (i23, j23) => {
            console.log('ongetHlsKey called.');
            if (this.mOnKeyGenerateListener != null) {
                let k23 = this.mOnKeyGenerateListener.getHlsKey(i23, j23);
                this.mOutKey = k23;
                console.log("get hlsKey, key: " + k23);
                return k23;
            }
            return "";
        };
        this.getHlsKeyInternal = () => {
            if (this.mOutKey) {
                return this.mOutKey;
            }
            return "";
        };
        premierlibrary.nHlsGenConstruct(this);
    }
}
