import { AVPLBase } from './AVPLBase';
import { Log } from '../utils/Log';
import { UrlVideoPlayer } from './UrlVideoPlayer';
import { OhosUrlListPlayer } from './nativeclass/OhosUrlListPlayer';
export class UrlVideoListPlayer extends AVPLBase {
    constructor(j45, k45) {
        super(j45, k45);
        this.mLog = new Log("NativePlayerBase_UrlVideoListPlayer");
        this.mUrlVideoPlayer = null;
        this.mUrlPrerenderPlayer = null;
    }
    createListPlayer(f45, g45, h45, i45) {
        return new OhosUrlListPlayer(f45, h45, i45, false);
    }
    getNativePlayerWithContext(d45, e45) {
        if (this.mUrlVideoPlayer == null) {
            this.mUrlVideoPlayer = new UrlVideoPlayer(d45, e45);
        }
        return this.mUrlVideoPlayer;
    }
    getPrerenderPlayerWithContext(b45, c45) {
        if (this.mUrlPrerenderPlayer == null) {
            this.mUrlPrerenderPlayer = new UrlVideoPlayer(b45, c45);
        }
        return this.mUrlPrerenderPlayer;
    }
    getCurrentPlayerIndex() {
        let a45 = super.getCorePlayer();
        if (a45 instanceof OhosUrlListPlayer) {
            this.mLog.info("getCurrentPlayerIndex");
            return a45.getCurrentPlayerIndex();
        }
        return -1;
    }
    getPreRenderPlayer() {
        let y44 = super.getCorePlayer();
        if (y44 instanceof OhosUrlListPlayer) {
            this.mLog.info("getPreRenderPlayer");
            let z44 = y44.getPreRenderPlayerIndex();
            return this.getCurrentPrerenderPlayer(z44);
        }
        return undefined;
    }
    addUrl(v44, w44) {
        let x44 = super.getCorePlayer();
        if (x44 instanceof OhosUrlListPlayer) {
            this.mLog.info("addUrl = " + v44 + " , uid = " + w44);
            x44.addUrl(v44, w44);
        }
    }
    moveToNext() {
        let u44 = super.getCorePlayer();
        if (u44 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNext");
            return u44.moveToNext(false);
        }
        return false;
    }
    moveToNextWithPrerendered() {
        let t44 = super.getCorePlayer();
        if (t44 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNextWithPrerendered");
            return t44.moveToNext(true);
        }
        return false;
    }
    moveToPrev() {
        let s44 = super.getCorePlayer();
        if (s44 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToPrev");
            return s44.moveToPrev();
        }
        return false;
    }
    moveTo(q44) {
        let r44 = super.getCorePlayer();
        if (r44 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveTo");
            return r44.moveTo(q44);
        }
        return false;
    }
    setUrlDataSource(o44) {
        let p44 = super.getNativePlayer();
        if (p44.setUrlDataSource !== undefined) {
            p44.setUrlDataSource(o44);
        }
    }
}
