export class VidPlayerConfigGen {
    constructor() {
        this.configMap = new Map();
    }
    addPlayerConfigNumber(b46, c46) {
        if (b46 != null) {
            this.configMap.set(b46, c46);
        }
    }
    addPlayerConfigString(z45, a46) {
        if (z45 != null) {
            this.configMap.set(z45, a46);
        }
    }
    setPreviewTime(y45) {
        this.addPlayerConfigNumber("PreviewTime", y45);
    }
    setEncryptType(x45) {
        if (x45 == EncryptType.AliyunVodEncryption) {
            this.addPlayerConfigString("EncryptType", "AliyunVoDEncryption");
        }
        else if (x45 == EncryptType.HLSEncryption) {
            this.addPlayerConfigString("EncryptType", "HLSEncryption");
        }
        else if (x45 == EncryptType.Unencrypted) {
            this.addPlayerConfigString("EncryptType", "Unencrypted");
        }
    }
    setMtsHlsUriToken(w45) {
        this.addPlayerConfigString("MtsHlsUriToken", w45);
    }
    genConfig() {
        let s45 = {};
        if (this.configMap.size == 0) {
            return "";
        }
        this.configMap.forEach((u45, v45) => {
            if (v45 != undefined && u45 != undefined) {
                s45[v45] = u45;
            }
        });
        return JSON.stringify(s45);
    }
}
export var EncryptType;
(function (r45) {
    r45[r45["Unencrypted"] = 0] = "Unencrypted";
    r45[r45["AliyunVodEncryption"] = 1] = "AliyunVodEncryption";
    r45[r45["HLSEncryption"] = 2] = "HLSEncryption";
})(EncryptType || (EncryptType = {}));
