import premierlibrary from 'libpremierlibrary.so';
import { Log } from '../../utils/Log';
import { Option, AudioStatus, } from '../IPlayer';
import { InfoBean } from '../bean/InfoBean';
import { findInfoCodeByValue, InfoCode } from '../bean/InfoCode';
import { findErrorCodeByValue } from '../bean/PlayerErrorCode';
import { ErrorInfo } from '../bean/ErrorInfo';
import { ObjCreateHelper } from '../../utils/ObjCreateHelper';
import { findNetworkLevelByCode } from './NetworkStats';
const log = new Log('NativePlayerBase');
export class NativePlayerBase {
    setHasListenerCallback(q32) {
        this.mHasListenerCallback = q32;
    }
    hasListener(p32) {
        if (this.mHasListenerCallback != null) {
            return this.mHasListenerCallback.hasListener(p32);
        }
        return false;
    }
    constructor(w28) {
        this.mNativeContext = BigInt(0);
        this.objHelper = new ObjCreateHelper();
        this.mHasListenerCallback = null;
        this.getNativeContext = () => {
            log.info(`getNativeContext, address: ${this.mNativeContext}`);
            return this.mNativeContext;
        };
        this.setNativeContext = (o32) => {
            log.info(`[addr check] setNativeContext, address: ${o32}`);
            this.mNativeContext = o32;
        };
        this.getHelper = () => {
            log.info(`getHelper`);
            return this.objHelper;
        };
        this.getContext = () => {
            log.info(`[addr check] getNativeContext, address: ${this.mNativeContext}`);
            return this.mContext;
        };
        this.onPrepared = () => {
            console.log('onPrepared called at nativePlayerBase.');
            if (this.mOnPreparedListener != null) {
                this.setOption('InOnPrepared', '1');
                this.mOnPreparedListener.onPrepared();
                this.setOption('InOnPrepared', '0');
            }
        };
        this.onCircleStart = () => {
            if (this.mOnInfoListener != null) {
                let n32 = new InfoBean();
                n32.setCode(InfoCode.LoopingStart);
                this.mOnInfoListener.onInfo(n32);
            }
        };
        this.onAutoPlayStart = () => {
            if (this.mOnInfoListener != null) {
                let m32 = new InfoBean();
                m32.setCode(InfoCode.AutoPlayStart);
                this.mOnInfoListener.onInfo(m32);
            }
        };
        this.onEvent = (i32, j32) => {
            if (this.mOnInfoListener != null) {
                let k32 = findInfoCodeByValue(i32);
                let l32 = new InfoBean();
                l32.setCode(k32);
                l32.setExtraMsg(j32);
                this.mOnInfoListener.onInfo(l32);
            }
        };
        this.onCurrentDownloadSpeed = (g32) => {
            if (this.mOnInfoListener != null) {
                let h32 = new InfoBean();
                h32.setCode(InfoCode.CurrentDownloadSpeed);
                h32.setExtraValue(g32);
                this.mOnInfoListener.onInfo(h32);
            }
        };
        this.onUtcTimeUpdate = (e32) => {
            if (this.mOnInfoListener != null) {
                let f32 = new InfoBean();
                f32.setCode(InfoCode.UtcTime);
                f32.setExtraValue(e32);
                this.mOnInfoListener.onInfo(f32);
            }
        };
        this.onLocalCacheLoad = (c32) => {
            if (this.mOnInfoListener != null) {
                let d32 = new InfoBean();
                d32.setCode(InfoCode.LocalCacheLoaded);
                d32.setExtraValue(c32);
                this.mOnInfoListener.onInfo(d32);
            }
        };
        this.onBufferedPositionUpdate = (a32) => {
            if (this.mOnInfoListener != null) {
                let b32 = new InfoBean();
                b32.setCode(InfoCode.BufferedPosition);
                b32.setExtraValue(a32);
                this.mOnInfoListener.onInfo(b32);
            }
        };
        this.onCurrentPositionUpdate = (y31) => {
            if (this.mOnInfoListener != null) {
                let z31 = new InfoBean();
                z31.setCode(InfoCode.CurrentPosition);
                z31.setExtraValue(y31);
                this.mOnInfoListener.onInfo(z31);
            }
        };
        this.onFirstFrameShow = () => {
            if (this.mOnRenderingStartListener != null) {
                this.mOnRenderingStartListener.onRenderingStart();
            }
        };
        this.onVideoSizeChanged = (w31, x31) => {
            if (this.mOnVideoSizeChangedListener != null) {
                this.mOnVideoSizeChangedListener.onVideoSizeChanged(w31, x31);
            }
        };
        this.onAudioInterruptEvent = (v31) => {
            if (this.mOnAudioInterruptEventListener != null) {
                if (v31 < AudioStatus.AUDIO_STATUS_DEFAULT || v31 > AudioStatus.AUDIO_STATUS_UNDUCK) {
                    log.info('onAudioInterruptEvent exception audioStatus: ' + v31);
                    this.mOnAudioInterruptEventListener.onAudioInterruptEvent(AudioStatus.AUDIO_STATUS_DEFAULT);
                    return;
                }
                this.mOnAudioInterruptEventListener.onAudioInterruptEvent(v31);
            }
        };
        this.onLoadingStart = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingBegin();
            }
        };
        this.onLoadingProgress = (u31) => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingProgress(u31, 0);
            }
        };
        this.onLoadingEnd = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingEnd();
            }
        };
        this.onAVNotSyncStart = (t31) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncStart(t31);
            }
        };
        this.onAVNotSyncEnd = (s31) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncEnd();
            }
        };
        this.onNetworkStats = (p31, q31) => {
            let r31 = findNetworkLevelByCode(q31);
            p31.networkLevel = r31;
            if (this.mOnNetworkStatsListener != null) {
                this.mOnNetworkStatsListener.onNetworkStats(p31);
            }
        };
        this.onSeekEnd = () => {
            if (this.mOnSeekCompleteListener != null) {
                this.mOnSeekCompleteListener.onSeekComplete();
            }
        };
        this.onStatusChanged = (n31, o31) => {
            log.info('onStatusChanged, newState: ' + n31 + ' oldState: ' + o31);
            if (this.mOnStateChangedListener != null) {
                this.mOnStateChangedListener.onStateChanged(n31);
            }
        };
        this.onCompletion = () => {
            if (this.mOnCompletionListener != null) {
                this.mOnCompletionListener.onCompletion();
            }
        };
        this.onVideoRendered = (l31, m31) => {
            if (this.mOnVideoRenderedListener != null) {
                this.mOnVideoRenderedListener.onVideoRendered(l31, m31);
            }
        };
        this.onShowSubtitle = (i31, j31, k31) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleShow(i31, j31, k31);
            }
        };
        this.onSubtitleExtAdded = (g31, h31) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleExtAdded(g31, h31);
            }
        };
        this.onHideSubtitle = (e31, f31) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHide(e31, f31);
            }
        };
        this.onSubtitleHeader = (c31, d31) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHeader(c31, d31);
            }
        };
        this.onError = (x30, y30, z30) => {
            let a31 = findErrorCodeByValue(x30);
            if (this.mOnErrorListener != null) {
                let b31 = new ErrorInfo();
                b31.setCode(a31);
                b31.setMsg(y30);
                b31.setExtra(z30);
                this.mOnErrorListener.onError(b31);
            }
        };
        this.onUrlExpired = (w30) => {
            if (this.mOnUrlExpiredListener != null) {
                this.mOnUrlExpiredListener.onUrlExpired(w30, null);
            }
        };
        this.onStreamSwitchSuc = (v30) => {
            if (this.mOnTrackChangedListener != null) {
                this.mOnTrackChangedListener.onChangedSuccess(v30);
            }
        };
        this.onStreamInfoGet = (u30) => {
            if (this.mOnTrackReadyListener != null) {
                this.mOnTrackReadyListener.onTrackReady(u30);
            }
        };
        this.onSubStreamInfoGet = (t30) => {
            if (this.mOnSubTrackReadyListener != null) {
                this.mOnSubTrackReadyListener.onSubTrackReady(t30);
            }
        };
        this.onSwitchStreamUrlResult = (o30, p30, q30) => {
            if (this.mOnStreamSwitchedListener == null) {
                return;
            }
            if (p30 == 0) {
                this.mOnStreamSwitchedListener.onSwitchedSuccess(o30);
            }
            else {
                let r30 = findErrorCodeByValue(p30);
                let s30 = new ErrorInfo();
                s30.setCode(r30);
                s30.setMsg(q30);
                this.mOnStreamSwitchedListener.onSwitchedFail(o30, s30);
            }
        };
        this.onCaptureScreen = (l30, m30, n30) => {
            if (this.mOnSnapShotListener != null) {
                this.mOnSnapShotListener.onSnapShot(n30, l30, m30);
            }
        };
        this.onSeiDataCallback = (j30, k30) => {
            if (this.mOnSeiDataListener != null) {
                this.mOnSeiDataListener.onSeiData(j30, new Uint8Array(k30));
            }
        };
        log.info('constructor_');
        this.mContext = w28;
        premierlibrary.nConstruct(this);
    }
    setOnPreparedListener(v28) {
        this.mOnPreparedListener = v28;
    }
    setOnInfoListener(u28) {
        this.mOnInfoListener = u28;
    }
    setOnRenderingStartListener(t28) {
        this.mOnRenderingStartListener = t28;
    }
    setOnStateChangedListener(s28) {
        this.mOnStateChangedListener = s28;
    }
    setOnCompletionListener(r28) {
        this.mOnCompletionListener = r28;
    }
    setOnLoadingStatusListener(q28) {
        this.mOnLoadingStatusListener = q28;
    }
    setOnErrorListener(p28) {
        this.mOnErrorListener = p28;
    }
    setOnVideoSizeChangedListener(o28) {
        this.mOnVideoSizeChangedListener = o28;
    }
    setOnSeekCompleteListener(n28) {
        this.mOnSeekCompleteListener = n28;
    }
    setOnSubtitleDisplayListener(m28) {
        this.mOnSubtitleDisplayListener = m28;
    }
    setOnUrlExpiredListener(l28) {
        this.mOnUrlExpiredListener = l28;
    }
    setOnVideoRenderedListener(k28) {
        this.mOnVideoRenderedListener = k28;
    }
    setOnAudioInterruptEventListener(j28) {
        this.mOnAudioInterruptEventListener = j28;
    }
    setOnTrackReadyListener(i28) {
        this.mOnTrackReadyListener = i28;
    }
    setOnSubTrackReadyListener(h28) {
        this.mOnSubTrackReadyListener = h28;
    }
    setOnStreamSwitchedListener(g28) {
        this.mOnStreamSwitchedListener = g28;
    }
    setOnAVNotSyncStatusListener(f28) {
        this.mOnAVNotSyncStatusListener = f28;
    }
    setOnNetworkStatsListener(e28) {
        this.mOnNetworkStatsListener = e28;
    }
    setOnTrackChangedListener(d28) {
        this.mOnTrackChangedListener = d28;
    }
    setOnSnapShotListener(c28) {
        this.mOnSnapShotListener = c28;
    }
    setOnSeiDataListener(b28) {
        this.mOnSeiDataListener = b28;
    }
    start() {
        log.info('nStart');
        premierlibrary.nStart(this);
    }
    pause() {
        log.info('nPause');
        premierlibrary.nPause(this);
    }
    stop() {
        log.info('nStop');
        premierlibrary.nStop(this);
    }
    prepare() {
        log.info('nPrepare');
        premierlibrary.nPrepare(this);
    }
    setAutoPlay(a28) {
        log.info('nSetAutoPlay');
        premierlibrary.nSetAutoPlay(this, a28);
    }
    setSurfaceId(z27) {
        log.info('nSetSurfaceId');
        premierlibrary.nSetSurfaceId(this, z27);
    }
    setSpeed(y27) {
        log.info('setSpeed');
        premierlibrary.nSetSpeed(this, y27);
    }
    switchStream(x27) {
        log.info('switchStream');
        premierlibrary.nSwitchStream(this, x27);
    }
    setAlphaRenderMode(w27) {
        log.info('setAlphaRenderMode');
        premierlibrary.nSetAlphaRenderMode(this, w27);
    }
    getAlphaRenderMode() {
        log.info('getAlphaRenderMode');
        return premierlibrary.nGetAlphaRenderMode(this);
    }
    selectTrack(v27) {
        log.info('selectTrack');
        premierlibrary.nSelectTrack(this, v27);
    }
    getCurrentTrack(t27) {
        log.info('getCurrentTrack, type: ' + t27);
        let u27 = premierlibrary.nGetCurrentStreamInfo(this, t27);
        return u27;
    }
    addExtSubtitle(s27) {
        log.info(`addExtSubtitle`);
        premierlibrary.nAddExtSubtitle(this, s27);
    }
    selectExtSubtitle(q27, r27) {
        log.info(`selectExtSubtitle`);
        premierlibrary.nSelectExtSubtitle(this, q27, r27);
    }
    setVolume(p27) {
        log.info('setVolume');
        premierlibrary.nSetVolume(this, p27);
    }
    getVolume() {
        log.info('getVolume');
        return premierlibrary.nGetVolume(this);
    }
    seekTo(n27, o27) {
        log.info('seekTo');
        premierlibrary.nSeekTo(this, n27, o27);
    }
    setStartTime(l27, m27) {
        log.info('setStartTime');
        premierlibrary.nSetStartTime(this, l27, m27);
    }
    getDuration() {
        log.info('getDuration');
        return premierlibrary.nGetDuration(this);
    }
    setGlobalTime(k27) {
        premierlibrary.nSetGlobalTime(this, k27);
    }
    getPlayedDuration() {
        log.info('getPlayedDuration');
        return premierlibrary.nGetPlayedDuration(this);
    }
    getCurrentPosition() {
        log.info('getCurrentPosition');
        return premierlibrary.nGetCurrentPosition(this);
    }
    getBufferedPosition() {
        log.info('getBufferedPosition');
        return premierlibrary.nGetBufferedPosition(this);
    }
    getPlayerStatus() {
        log.info('getPlayerStatus');
        return premierlibrary.nGetPlayerStatus(this);
    }
    setTraceId(j27) {
        log.info('setTraceId');
        premierlibrary.nSetTraceId(this, j27);
    }
    enableHardwareDecoder(i27) {
        log.info('enableHardwareDecoder');
        premierlibrary.nEnableHardwareDecoder(this, i27);
    }
    release() {
        log.info('release');
        premierlibrary.nRelease(this);
    }
    setMute(h27) {
        log.info('setMute');
        premierlibrary.nSetMute(this, h27);
    }
    isMuted() {
        log.info('isMuted');
        return premierlibrary.nIsMuted(this) === 1;
    }
    setScaleMode(g27) {
        log.info('setScaleMode');
        premierlibrary.nSetScaleMode(this, g27);
    }
    getScaleMode() {
        log.info('getScaleMode');
        return premierlibrary.nGetScaleMode(this);
    }
    setLoop(f27) {
        log.info('setLoop');
        premierlibrary.nSetLoop(this, f27);
    }
    isLoop() {
        log.info('isLoop');
        return premierlibrary.nIsLoop(this) === 1;
    }
    getVideoWidth() {
        log.info('getVideoWidth');
        return premierlibrary.nGetVideoWidth(this);
    }
    getVideoHeight() {
        log.info('getVideoHeight');
        return premierlibrary.nGetVideoHeight(this);
    }
    getVideoRotation() {
        log.info('getVideoRotation');
        return premierlibrary.nGetVideoRotation(this);
    }
    reload() {
        log.info('reload');
        premierlibrary.nReload(this);
    }
    setRotateMode(e27) {
        log.info('setRotateMode');
        premierlibrary.nSetRotateMode(this, e27);
    }
    getRotateMode() {
        log.info('getRotateMode');
        return premierlibrary.nGetRotateMode(this);
    }
    setMirrorMode(d27) {
        log.info('setMirrorMode');
        premierlibrary.nSetMirrorMode(this, d27);
    }
    getMirrorMode() {
        log.info('getMirrorMode');
        return premierlibrary.nGetMirrorMode(this);
    }
    setVideoBackgroundColor(c27) {
        log.info('setVideoBackgroundColor');
        premierlibrary.nSetVideoBackgroundColor(this, c27);
    }
    getSpeed() {
        log.info('getSpeed');
        return premierlibrary.nGetSpeed(this);
    }
    isAutoPlay() {
        log.info('isAutoPlay');
        return premierlibrary.nIsAutoPlay(this) === 1;
    }
    isAutoBandWidth() {
        log.info('isAutoBandWidth');
        return premierlibrary.nIsAutoBandWidth(this) === 1;
    }
    setAutoBandWidth(b27) {
        log.info('nSetAutoBandWidth');
        premierlibrary.nSetAutoBandWidth(this, b27);
    }
    setConfig(a27) {
        log.info('setConfig');
        premierlibrary.nSetConfig(this, a27);
        this.mPlayerConfig = a27;
    }
    getConfig() {
        log.info('getConfig');
        let z26 = premierlibrary.nGetConfig(this);
        return z26;
    }
    setPlayerScene(y26) {
        log.info('setPlayerScene');
        premierlibrary.nSetPlayerScene(this, y26);
    }
    setOption(w26, x26) {
        log.info('setOption');
        premierlibrary.nSetOption(this, w26, x26);
    }
    getOption(t26) {
        let u26 = premierlibrary.nGetOption(this, t26);
        if (t26 == Option.RenderFPS ||
            t26 == Option.DownloadBitrate ||
            t26 == Option.VideoBitrate ||
            t26 == Option.AudioBitrate) {
            let v26 = parseFloat(u26);
            return v26;
        }
        return u26;
    }
    setStreamDelay(r26, s26) {
        log.info('setStreamDelay');
        premierlibrary.nSetStreamDelay(this, r26, s26);
    }
    setMaxAccurateSeekDelta(q26) {
        log.info('setMaxAccurateSeekDelta');
        premierlibrary.nSetMaxAccurateSeekDelta(this, q26);
    }
    setCacheConfig(p26) {
        log.info('setCacheConfig');
        premierlibrary.nSetCacheConfig(this, p26);
    }
    setIPResolveType(o26) {
        log.info('setIPResolveType');
        premierlibrary.nSetIPResolveType(this, o26);
    }
    setFastStart(n26) {
        log.info('setFastStart');
        premierlibrary.nSetFastStart(this, n26);
    }
    snapShot() {
        log.info('snapShot');
        premierlibrary.nSnapShot(this);
    }
    clearScreen() {
        log.info('clearScreen');
        premierlibrary.nClearScreen(this);
    }
    getSdkVersion() {
        log.info('getSdkVersion');
        return premierlibrary.nGetSdkVersion();
    }
    getCacheFilePathByUrl(m26) {
        log.info('getCacheFilePathByUrl');
        return premierlibrary.nGetCacheFilePathByUrl(this, m26);
    }
    getCacheFilePathByVid(i26, j26, k26, l26) {
        log.info('getCacheFilePathByVid');
        return premierlibrary.nGetCacheFilePathByVid(this, i26, j26, k26, l26);
    }
    getPropertyString(h26) {
        log.info('getPropertyString');
        return premierlibrary.nGetPropertyString(this, h26);
    }
    setDefaultBandWidth(g26) {
        log.info('setDefaultBandWidth');
        premierlibrary.nSetDefaultBandWidth(this, g26);
    }
    setDefaultResolution(f26) {
        log.info('setDefaultResolution');
        premierlibrary.nSetDefaultResolution(this, f26);
    }
    sendCustomEvent(e26) {
        log.info('sendCustomEvent');
        premierlibrary.nSendCustomEvent(this, e26);
    }
    setVideoTag(d26) {
        log.info('setVideoTag');
        premierlibrary.nSetVideoTag(this, d26);
    }
    setUserData(c26) {
        log.info('setUserData');
        premierlibrary.nSetUserData(this, c26);
    }
    getUserData() {
        log.info('getUserData');
        return premierlibrary.nGetUserData(this);
    }
    refreshPlayerUrl(b26) {
        log.info('refreshPlayerUrl');
        premierlibrary.nRefreshPlayerUrl(this, b26);
    }
    refreshPlayerUrlWithError(a26) {
        log.info('refreshPlayerUrlWithError');
        premierlibrary.nRefreshPlayerUrlWithError(this, a26);
    }
    getNativeContextAddr() {
        return this.mNativeContext;
    }
}
