import { SourceBase } from './SourceBase';
import { Definition } from './Definition';
export class VidSourceBase extends SourceBase {
    constructor() {
        super();
        this.mPlayConfig = null;
        this.mOutputType = null;
        this.mStreamTypes = null;
        this.mResultType = null;
        this.mDigitalWatermarkType = null;
        this.nativeGetOutputTypeStr = () => {
            if (this.mOutputType == null) {
                return "";
            }
            else {
                return this.mOutputType.toString();
            }
        };
        this.nativeGetReAuthInfoStr = () => {
            return this.mReAuthInfo;
        };
        this.nativeGetResultTypeStr = () => {
            if (this.mResultType == null) {
                return "";
            }
            else {
                return this.mResultType;
            }
        };
        this.nativeGetStreamTypeStr = () => {
            if (this.mStreamTypes == null || this.mStreamTypes.size == 0) {
                return "";
            }
            let q43 = "";
            for (let r43 of this.mStreamTypes) {
                if (r43 != null) {
                    q43 += r43 + ",";
                }
            }
            if (q43.length > 0) {
                q43 = q43.slice(0, -1);
            }
            return q43;
        };
        this.nativeGetDefinitionStr = () => {
            if (this.mDefinitions == null || this.mDefinitions.length == 0) {
                return "";
            }
            if (this.mDefinitions.includes(Definition.DEFINITION_AUTO, 0)) {
                return Definition.DEFINITION_AUTO;
            }
            let o43 = "";
            for (let p43 of this.mDefinitions) {
                if (p43 != null) {
                    o43 += p43 + ",";
                }
            }
            if (o43.length > 0) {
                o43 = o43.slice(0, -1);
            }
            return o43;
        };
        this.nativeGetPlayerConfigStr = () => {
            if (this.mPlayConfig == null) {
                return "";
            }
            else {
                return this.mPlayConfig.genConfig();
            }
        };
        this.nativeGetFormatStr = () => {
            return this.getFormatStr();
        };
        this.nativeGetAuthTimeout = () => {
            return this.mAuthTimeout;
        };
        this.nativeGetTrace = () => {
            return this.mTrace;
        };
        this.nativeGetDigitalWatermarkTypeStr = () => {
            if (this.mDigitalWatermarkType == null) {
                return "";
            }
            else {
                return this.mDigitalWatermarkType.toString();
            }
        };
        this.mFormats = [];
        this.mDefinitions = [];
        this.mReAuthInfo = "";
        this.mAuthTimeout = 3600;
        this.mTrace = "";
    }
    getPlayerConfig() {
        if (this.mPlayConfig == null) {
            return "";
        }
        else {
            return this.mPlayConfig.genConfig();
        }
    }
    setPlayerConfig(d43) {
        this.mPlayConfig = d43;
    }
    getFormats() {
        return this.mFormats;
    }
    setFormats(c43) {
        this.mFormats = c43;
    }
    getFormatStr() {
        if (this.mFormats.length == 0) {
            return "";
        }
        let a43 = "";
        for (let b43 of this.mFormats) {
            if (b43 != null) {
                a43 += b43 + ",";
            }
        }
        if (a43.length > 0) {
            a43 = a43.slice(0, -1);
        }
        return a43;
    }
    setDefinition(z42) {
        this.mDefinitions = z42;
    }
    getOutputType() {
        return this.mOutputType;
    }
    setOutputType(y42) {
        this.mOutputType = y42;
    }
    setAuthTimeout(x42) {
        this.mAuthTimeout = x42;
    }
    setTrace(w42) {
        this.mTrace = w42;
    }
    setDigitalWatermarkType(v42) {
        this.mDigitalWatermarkType = v42;
    }
    getTrace() {
        return this.mTrace;
    }
    getDigitalWatermarkType() {
        return this.mDigitalWatermarkType;
    }
}
export var OutputType;
(function (u42) {
    u42["oss"] = "oss";
    u42["cdn"] = "cdn";
})(OutputType || (OutputType = {}));
export var StreamType;
(function (t42) {
    t42["video"] = "video";
    t42["audio"] = "audio";
})(StreamType || (StreamType = {}));
export var ResultType;
(function (s42) {
    s42["Single"] = "Single";
    s42["Multiple"] = "Multiple";
})(ResultType || (ResultType = {}));
export var DigitalWatermarkType;
(function (r42) {
    r42["TraceMark"] = "TraceMark";
    r42["CopyrightMark"] = "CopyrightMark";
})(DigitalWatermarkType || (DigitalWatermarkType = {}));
