export class BaseRequest {
    constructor(j47) {
        this.wantStop = false;
        this.outerListener = null;
        this.outerListener = j47;
    }
    getSync() {
        this.runInBackground();
    }
    getAsync() {
        this.runInBackgroundAsync();
    }
    runInBackgroundAsync() {
        setTimeout(() => {
            this.runInBackground();
        }, 0);
    }
    stop() {
        this.wantStop = true;
        this.stopInner();
    }
    sendSuccessResult(g47, h47) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onSuccess(g47, h47);
        }
    }
    sendFailResult(d47, e47, f47) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onFail(d47, e47, f47);
        }
    }
    dealMsg(c47) {
        if (c47.id == BaseRequest.WHAT_SUCCESS) {
            this.outerListener?.onSuccess(c47.data, c47.extra);
        }
        else if (c47.id == BaseRequest.WHAT_FAIL) {
            this.outerListener?.onFail(c47.failCode, c47.data, c47.extra);
        }
    }
}
BaseRequest.WHAT_SUCCESS = 1;
BaseRequest.WHAT_FAIL = 0;
BaseRequest.DATA_KEY_EXTRA = "data_extra";
