import http from '@ohos.net.http';
import util from "@ohos.util";
export class HttpClientHelper {
    constructor(g48) {
        this.mReferer = null;
        this.urlRequest = null;
        this.mNetworkTimeout = HttpClientHelper.CONNECTION_TIMEOUT;
        this.mHttpProxy = null;
        this.mUserAgent = null;
        this.mCustomHeaders = [{}];
        this.mUrl = g48;
    }
    setRefer(f48) {
        this.mReferer = f48;
    }
    setTimeout(e48) {
        this.mNetworkTimeout = e48;
    }
    setHttpProxy(d48) {
        this.mHttpProxy = d48;
    }
    setUserAgent(c48) {
        this.mUserAgent = c48;
    }
    setCustomHeaders(b48) {
        this.mCustomHeaders = b48;
    }
    stop() {
        if (this.urlRequest != null) {
            setTimeout(() => {
                this.urlRequest?.destroy();
            }, 0);
        }
    }
    async doGet() {
        if (this.mUrl.startsWith("https://") || this.mUrl.startsWith("http://")) {
            this.urlRequest = http.createHttp();
        }
        else {
            return null;
        }
        if (this.urlRequest == null) {
            return null;
        }
        let n47 = [];
        if (this.mReferer != null) {
            n47.push({ 'Referer': this.mReferer });
        }
        if (this.mUserAgent != null) {
            n47.push({ 'User-Agent': this.mUserAgent });
        }
        if (this.mCustomHeaders.length > 0) {
            for (let z47 of this.mCustomHeaders) {
                if (z47 != null) {
                    n47.push(z47);
                }
            }
        }
        let o47 = "";
        let p47 = false;
        if (this.mHttpProxy != null) {
            o47 = this.mHttpProxy;
            p47 = true;
        }
        else {
            o47 = this.mUrl;
        }
        let q47 = {
            method: http.RequestMethod.GET,
            header: n47,
            connectTimeout: this.mNetworkTimeout,
            readTimeout: this.mNetworkTimeout,
            usingProxy: p47,
        };
        return new Promise((s47, t47) => {
            if (this.urlRequest == null) {
                s47(null);
                return;
            }
            this.urlRequest.request(o47, q47, (v47, w47) => {
                if (v47) {
                    console.error('error:' + JSON.stringify(v47));
                    this.urlRequest?.destroy();
                    s47(null);
                    return;
                }
                if (w47.responseCode == http.ResponseCode.OK) {
                    if (w47.resultType == http.HttpDataType.STRING) {
                        s47(w47.result);
                    }
                    else if (w47.resultType == http.HttpDataType.ARRAY_BUFFER) {
                        let x47 = util.TextDecoder.create('utf-8');
                        let y47 = x47.decodeToString(new Uint8Array(w47.result));
                        s47(y47 ? y47 : null);
                    }
                    else {
                        console.info("response failed, resultType: " + w47.resultType);
                        this.urlRequest?.destroy();
                        s47(null);
                    }
                }
                else {
                    console.info("response failed, responseCode is " + w47.responseCode);
                    this.urlRequest?.destroy();
                    s47(null);
                }
            });
        });
    }
}
HttpClientHelper.CONNECTION_TIMEOUT = 10000;
