import premierlibrary from 'libpremierlibrary.so';
export class Logger {
    constructor() {
        this.mValue = -1;
        this.mLogCallback = null;
        this.mEnableConsoleLog = true;
        this.mCurrentLogLevel = LogLevel.AF_LOG_LEVEL_INFO;
        this.nOnLogCallback = (b49, c49) => {
            let d49 = Logger.getLevel(b49);
            if (Logger.sAppContext != null) {
                Logger.getInstance(Logger.sAppContext).callback(d49, c49);
            }
        };
        premierlibrary.nLoggerConstruct(this);
    }
    static getInstance(z48) {
        if (Logger.sInstance == null) {
            Logger.sInstance = new Logger();
            Logger.sInstance.setLogLevel(LogLevel.AF_LOG_LEVEL_INFO);
            if (z48 != null) {
                Logger.sAppContext = z48;
            }
        }
        return Logger.sInstance;
    }
    setLogCallback(y48) {
        this.mLogCallback = y48;
    }
    getLogCallback() {
        return this.mLogCallback;
    }
    setLogLevel(x48) {
        this.mCurrentLogLevel = x48;
        premierlibrary.nLoggerSetLevel(x48);
    }
    setLogOption(v48, w48) {
        switch (v48) {
            case LogOption.FRAME_LEVEL_LOGGING_ENABLED:
                premierlibrary.nLoggerSetOption("frame_level_logging_enabled", w48);
                break;
        }
    }
    getLogLevel() {
        let u48 = premierlibrary.nLoggerGetLevel();
        return Logger.getLevel(u48);
    }
    enableConsoleLog(t48) {
        this.mEnableConsoleLog = t48;
        premierlibrary.nLoggerEnableConsole(t48);
    }
    callback(r48, s48) {
        if (this.mLogCallback != null) {
            this.mLogCallback.onLog(r48, s48);
        }
    }
    static getLevel(q48) {
        switch (q48) {
            case 0:
                return LogLevel.AF_LOG_LEVEL_NONE;
            case 8:
                return LogLevel.AF_LOG_LEVEL_FATAL;
            case 16:
                return LogLevel.AF_LOG_LEVEL_ERROR;
            case 24:
                return LogLevel.AF_LOG_LEVEL_WARNING;
            case 32:
                return LogLevel.AF_LOG_LEVEL_INFO;
            case 48:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
            case 56:
                return LogLevel.AF_LOG_LEVEL_TRACE;
            default:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
        }
    }
}
export var LogLevel;
(function (p48) {
    p48[p48["AF_LOG_LEVEL_NONE"] = 0] = "AF_LOG_LEVEL_NONE";
    p48[p48["AF_LOG_LEVEL_FATAL"] = 8] = "AF_LOG_LEVEL_FATAL";
    p48[p48["AF_LOG_LEVEL_ERROR"] = 16] = "AF_LOG_LEVEL_ERROR";
    p48[p48["AF_LOG_LEVEL_WARNING"] = 24] = "AF_LOG_LEVEL_WARNING";
    p48[p48["AF_LOG_LEVEL_INFO"] = 32] = "AF_LOG_LEVEL_INFO";
    p48[p48["AF_LOG_LEVEL_DEBUG"] = 48] = "AF_LOG_LEVEL_DEBUG";
    p48[p48["AF_LOG_LEVEL_TRACE"] = 56] = "AF_LOG_LEVEL_TRACE";
})(LogLevel || (LogLevel = {}));
export var LogOption;
(function (o48) {
    o48[o48["FRAME_LEVEL_LOGGING_ENABLED"] = 1] = "FRAME_LEVEL_LOGGING_ENABLED";
})(LogOption || (LogOption = {}));
