import { AppPlugin } from '@ohos/hvigor-ohos-plugin/src/plugin/app-plugin.js';
/**
 * ArkUI跨平台plugin对外暴露app级别的接口和任务的plugin
 * 继承了ohos-plugin的能力，且对部分Task进行hook，处理ArkUI跨平台相关逻辑
 *
 * @since 2022/11/24
 */
export declare class CrossplatformAppPlugin {
    private readonly log;
    private appPlugin;
    private _projectModel;
    private _project;
    private clean;
    private assembleApp;
    private syncProject;
    constructor(appPlugin: AppPlugin);
    initCrossPlatformService(): void;
    initHookTask(): Promise<void>;
    initAndroidTask(): void;
    initIosTask(): void;
    /**
     * 跨平台工程前置检查
     * 校验返回false时，不挂载跨平台任务
     *
     * @return {boolean} true校验通过，false校验不通过
     */
    preCheck(): boolean;
    checkProject(): void;
    private checkApiVersion;
    private checkAndroidProject;
    private readFile;
    private validateSdkDir;
    private checkArkUIXProfile;
}
