"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var toString_1 = __importDefault(require("./toString"));
var words_1 = __importDefault(require("./words"));
var upperFirst_1 = __importDefault(require("./upperFirst"));
var toLower_1 = __importDefault(require("./toLower"));
/**
 * 转换字符串 str 为驼峰写法。例如 `smallBoy`。
 * @Since 1.0.0
 * @Catalog String
 * @param [str = ''] (string): 要转换的字符串。
 * @returns (string): 返回驼峰写法的字符串。
 * @example
 * _.camelCase('Foo Bar');
 * // => 'fooBar'
 *
 * _.camelCase('--foo-bar--');
 * // => 'fooBar'
 *
 * _.camelCase('__FOO_BAR__');
 * // => 'fooBar'
 */
function camelCase(str) {
    if (str === void 0) { str = ''; }
    if ((0, isNil_1.default)(str)) {
        return str;
    }
    var strValue = str;
    if (typeof str !== 'string') {
        strValue = (0, toString_1.default)(str);
    }
    return (0, words_1.default)(strValue.replace(/['\u2019]/g, '')).reduce(function (result, currentWord, idx) {
        var word = (0, toLower_1.default)(currentWord);
        return result + (idx === 0 ? word : (0, upperFirst_1.default)(word));
    }, '');
}
exports.default = camelCase;
