/**
 * 检查 path 是否是object对象的直接属性，根据多段路径查询嵌套对象
 *
 * @private
 * @param {Object} object 要查询的对象
 * @param {Array|string} path 要查询的路径。多段路径由英文句号.隔开
 * @param {Function} hasFunc 是否属于当前遍历层级的对象的判断方法
 * @returns {boolean} 该路径能在该对象查找到，则为true，否则为false
 */
export default function hasPath(object: Object, path: string | string[], hasFunc: (object: Object, path: string | string[]) => boolean): boolean;
