"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.needDeeperCompare = void 0;
var utils_1 = require("./common/utils");
var keys_1 = __importDefault(require("./keys"));
var isNaN_1 = __importDefault(require("./isNaN"));
/**
 * 判断value是不是{}或者[]等比较复杂的变量
 * @param value
 */
function isValueComplex(value) {
    return typeof value === 'object' && value !== null;
}
/**
 * 判断objValue和srcValue是否需要进一步递归调用isMatch来得知它们是否算匹配
 * @param objValue
 * @param srcValue
 */
function needDeeperCompare(objValue, srcValue) {
    return isValueComplex(objValue) && isValueComplex(srcValue);
}
exports.needDeeperCompare = needDeeperCompare;
/**
 * 对isMatch函数的原始输入做一些转换
 * @param rawObj
 * @param rawSource
 */
function transformRawInputs(rawObj, rawSource) {
    // 对原始输入做一些转换
    var obj = rawObj;
    // 如果rawObj是数组或者Set，后面可能用到splice，故先复制一份
    if (Array.isArray(rawObj) || (0, utils_1.tagName)(rawObj) === '[object Set]') {
        obj = __spreadArray([], __read(rawObj), false);
    }
    else if ((0, utils_1.tagName)(rawObj) === '[object Map]') {
        // map直接转为对象
        obj = Object.fromEntries(rawObj.entries());
    }
    var source = rawSource;
    if ((0, utils_1.tagName)(rawSource) === '[object Set]') {
        source = __spreadArray([], __read(rawSource), false);
    }
    else if ((0, utils_1.tagName)(rawSource) === '[object Map]') {
        source = Object.fromEntries(rawSource.entries());
    }
    return { obj: obj, source: source };
}
/**
 * 递归的判断rawObj和rawSource是否匹配。rawObj可以包含多余rawSource的属性
 * @param rawObj，要比较的对象
 * @param rawSource，要比较的参考对象，rawObj至少需要包含rawSource中的所有属性，才算匹配
 * @return 一个boolean，表示两者是否匹配
 */
function isMatch(rawObj, rawSource) {
    var e_1, _a;
    var _b = transformRawInputs(rawObj, rawSource), obj = _b.obj, source = _b.source;
    // 包含obj原型链上的所有key
    var objKeys = (0, utils_1.getObjectKeysWithProtoChain)(obj);
    // 不能包含source原型链上的key
    var sourceKeys = source === undefined || source === null
        ? [] : (0, keys_1.default)(source);
    var _loop_1 = function (sourceKey) {
        var srcValue = source[sourceKey];
        // 如果两者都是数组，只需要srcValue在obj中被任一元素match到即可
        if (Array.isArray(obj) && Array.isArray(source)) {
            var foundIndex = obj.findIndex(function (v) { return (isValueComplex(srcValue) ? isMatch(v, srcValue) : v === srcValue); });
            // 如果obj中有元素match到srcValue，则将其从obj中去除，因为每个obj元素只能match一次
            if (foundIndex !== -1) {
                obj.splice(foundIndex, 1);
                return "continue";
            }
        }
        // 判断obj中有没有相同的key，如果没有，则return false
        var objKey = objKeys.find(function (k) { return k === sourceKey; });
        if (!objKey) {
            return { value: false };
        }
        /*
         * 判断srcValue和objValue是否match，如果它们都是简单值（字符串、布尔等），直接用===比较
         * 但如果它们是对象或者数组，不能简单比较，需要进一步递归调用isMatch来比较
         */
        var objValue = obj[objKey];
        if (needDeeperCompare(objValue, srcValue)) {
            if (!isMatch(objValue, srcValue)) {
                return { value: false };
            }
        }
        else if ((0, isNaN_1.default)(srcValue) && (0, isNaN_1.default)(obj)) {
            return "continue";
        }
        else if (objValue !== srcValue) {
            return { value: false };
        }
    };
    try {
        for (var sourceKeys_1 = __values(sourceKeys), sourceKeys_1_1 = sourceKeys_1.next(); !sourceKeys_1_1.done; sourceKeys_1_1 = sourceKeys_1.next()) {
            var sourceKey = sourceKeys_1_1.value;
            var state_1 = _loop_1(sourceKey);
            if (typeof state_1 === "object")
                return state_1.value;
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (sourceKeys_1_1 && !sourceKeys_1_1.done && (_a = sourceKeys_1.return)) _a.call(sourceKeys_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return true;
}
exports.default = isMatch;
