"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStartIndex = void 0;
/**
 * 获取开始查找的索引位置
 * @param array
 * @param start
 */
var getStartIndex = function (array, start) {
    var startIndex = start === undefined ? array.length - 1 : start;
    startIndex = [null, false, 0, NaN, ''].includes(start) ? 0 : Number(startIndex);
    startIndex = Math.ceil(Number(startIndex) < 0 ? Math.max(array.length + Number(startIndex), 0) : startIndex);
    return startIndex;
};
exports.getStartIndex = getStartIndex;
/**
 * 检查value在array数组中首次被找到的索引值
 * @param array
 * @param value
 * @param start
 */
function lastIndexOf(array, value, start) {
    if (array === null || array === undefined) {
        return -1;
    }
    var resIndex = -1;
    var startIndex = (0, exports.getStartIndex)(array, start);
    for (var i = (startIndex > array.length - 1 ? array.length - 1 : startIndex); i >= 0; i--) {
        if (array[i] === value) {
            resIndex = i;
            break;
        }
    }
    return resIndex;
}
exports.default = lastIndexOf;
