import { InstrumenterOpts } from '../types/instrumenter';
/**
 * Instrumenter类是该库的一个公共API
 * @param {Object} opts optional.
 * @param {string} [opts.coverageVariable=__coverage__] name of global coverage variable.
 * @param {boolean} [opts.compact=true] generate compact code.
 * @param {boolean} [opts.esModules=false] set to true to instrument ES6 modules.
 * @param {boolean} [opts.reportLogic=false] report boolean value of logical expressions.
 * @param {boolean} [opts.preserveComments=false] preserve comments in output.
 * @param {boolean} [opts.autoWrap=false] set to true to allow `return` statements outside of functions..
 * @param {array} [opts.parserPlugins] - set babel parser plugins, see @istanbuljs/schema for defaults.
 * @param {string} [opts.coverageGlobalScope=this] the global coverage variable scope.
 * @param {Array} [opts.ignoreClassMethods=[]] set to array of class method names to ignore for coverage.
 * @param {Function} [opts.sourceMapUrlCallback=null] a callback function that is called when a source map URL
 *     is found in the original code. This function is called with the source file name and the source map URL.
 * @param {boolean} [opts.debug=false] - turn debugging on.
 * @param {boolean} [opts.produceSourceMap=false] set to true to produce a source map for the instrumented code
 * @param {boolean} [opts.coverageGlobalScopeFunc=true] use an evaluated function to find coverageGlobalScope.
 */
declare class Instrumenter {
    opts: InstrumenterOpts;
    private fileCoverage;
    private sourceMap;
    constructor(opts?: {});
    instrumentSync(code: string, filename: string, inputSourceMap?: any): string;
    private getBabelOpts;
    /**
     * 返回最近一次的文件覆盖率对象
     * @returns the file coverage object.
     */
    lastFileCoverage(): any;
    /**
     * 返回最近一次的文件的sourcemap
     * @returns the source map object.
     */
    lastSourceMap(): any;
}
export { Instrumenter };
