"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.report = void 0;
const fs = require("fs");
const libCoverage = require("istanbul-lib-coverage");
const libReport = require("istanbul-lib-report");
const reports = require("istanbul-reports");
const fsExtra = require("fs-extra");
const log4js = require("log4js");
const logger = log4js.getLogger();
/**
 * 功能：生成覆盖率报告
 * @param etsCoverageData ets覆盖率数据
 * @param reportPath 报告生成路径
 */
function report(etsCoverageData, reportPath) {
    try {
        // 如果存在reports文件夹则删除
        if (fs.existsSync(reportPath)) {
            fsExtra.rmSync(reportPath, { recursive: true });
        }
        const coverageData = etsCoverageData;
        const coverageObj = JSON.parse(coverageData);
        const coverageMap = libCoverage.createCoverageMap(coverageObj);
        // create summary report
        const summary = libCoverage.createCoverageSummary();
        coverageMap.files().forEach(function (f) {
            let fc = coverageMap.fileCoverageFor(f), s = fc.toSummary();
            summary.merge(s);
        });
        // create a context for report generation
        const configWatermarks = {
            statements: [50, 80],
            functions: [50, 80],
            branches: [50, 80],
            lines: [50, 80],
        };
        const context = libReport.createContext({
            dir: reportPath,
            // The summarizer to default to (may be overridden by some reports)
            // values can be nested/flat/pkg. Defaults to 'pkg'
            defaultSummarizer: 'nested',
            watermarks: configWatermarks,
            coverageMap,
        });
        // create an instance of the relevant report class, passing the
        // report name e.g. json/html/html-spa/text
        const report = reports.create('html', {});
        // call execute to synchronously create and write the report to disk
        report.execute(context);
    }
    catch (err) {
        logger.error('report failed, error:' + err);
    }
}
exports.report = report;
