declare type logType = string | number | Object;
export interface LogEvent {
    time: Date;
    category: string;
    level: string;
    msg: string | number | Object;
    type: string;
    fileId?: string;
}
export declare class LogCore {
    private _debugLog;
    private _infoLog;
    private _warnLog;
    private _errorLog;
    private _log;
    private readonly _category;
    private readonly _type;
    constructor(category: string, type: string);
    getDebugLogs(): LogEvent[];
    debug(...values: logType[]): void;
    getInfoLogs(): LogEvent[];
    info(...values: logType[]): void;
    getWarnLogs(): LogEvent[];
    warn(...values: logType[]): void;
    getErrorLogs(): LogEvent[];
    error(...values: logType[]): void;
    getLogs(): LogEvent[];
    private logMsg;
    private getLogEvent;
}
export declare class ArktsBaseLogger {
    protected static _logMap: Map<string, LogCore>;
    protected static _logEvents: LogEvent[];
    private static _logEventsHasError;
    private static sendLog;
    private static tsWatchCb;
    private static lastLogEvents;
    static setLogCallback(sendLogCb: (logs: LogEvent[], lastReUsedFiles?: Set<string>) => void, tsWatchEndCb: () => void): void;
    static addLastLogEvents(logEvents: LogEvent[]): void;
    static getLastLogEvents(): LogEvent[];
    static getPluginLogger(category: string): LogCore;
    static getLogger(category: string, type?: string): LogCore;
    static getLogMap(): Map<string, LogCore>;
    static addLogEvent(log: LogEvent): void;
    static getLogEvents(): LogEvent[];
    static checkLoggerHaveErrorInfo(): boolean;
    static sendLastLogEvents(lastReUsedFiles: Set<string>): void;
    static clearLogEvents(): void;
    private static checkTsWatchEnd;
    static reset(): void;
}
export {};
