import { Component } from './component';
import { PathAndApiVersion } from './path-and-apiversion';
export interface SdkInfoHandler {
    /**
     * 获取本地已安装的SDK
     *
     * @return 本地已安装sdk集合
     */
    getLocalSdks(): Map<PathAndApiVersion, Component>;
    /**
     * 检查本地的组件是否有每个path和版本对应的sdk，如果有sdk，就不下载，如果缺少，就去下载对应版本的组件。
     * 下载完毕后，以path->SdkComponent的形式返回，中间有任何一个组件下载失败，或者不存在，就认为是失败，直接抛异常
     * 返回一个Promise，通过Promise.then()获取SDK信息
     *
     * @return Promise<Map<PathAndApiVersion, Component>>
     */
    getOrDownload(pathAndApiVersions: PathAndApiVersion[]): Promise<Map<PathAndApiVersion, Component>>;
}
