export declare enum Status {
    OK = 0,
    INFO = 1,
    WARN = 2,
    ERROR = 3
}
export declare class SdkValidation {
    readonly status: Status;
    readonly message: string;
    constructor(status: Status, message: string);
    static SUCCESS: SdkValidation;
    static error(message: string): SdkValidation;
    static warn(message: string): SdkValidation;
    static info(message: string): SdkValidation;
}
export interface Validator {
    validator(sdkPath: string): SdkValidation;
}
export declare class ValidatorChains implements Validator {
    private _validatorList;
    addValidator(validator: Validator): ValidatorChains;
    validator(sdkPath: string): SdkValidation;
    static create(): ValidatorChains;
}
