import { ModuleModel } from '../../model/module/module-model.js';
import { ProjectModel } from '../../model/project/project-model.js';
import { BuildOpt } from '../../options/build/build-opt.js';
/**
 * 1. 工程级别中product和buildMode中的无name的buildOption
 * merge(opt1, opt2, "MERGE") opt2的同名处理冲突的优先级别>opt1 以key为关键字进行递归的merge合并,数组之类的集合对象不需要单独进行合并
 *
 * 2. 模块级别的buildOptionSet中的有name的buildOption => 不允许重名
 *
 * 3. 处理上一步的buildOptionSet 和 模块中历史遗留的顶层的default的buildOption
 * buildOptionSet中的同名配置优先级更高,且采用overwrite的策略
 *
 * 4. 模块级别继承工程级别合并后的buildOption
 * 取上一步合并后的buildOptionSet中的每一个buildOption与该继承过来的buildOption做一个merge，并且buildOptionSet中的buildOption的优先级更高
 *
 * 5. 根据buildMode和buildOptionBinder可以从上一步处理的set中找到一个target对应的唯一一个buildOption
 *
 * 6. target中的配置的无name的buildOption与上一步中得到的buildOption
 * target中的buildOption优先级更高，且采用merge的策略与上一步的buildOption合并
 *
 * 7. 命令行处理
 */
export declare class BuildModeManager {
    private productBuildOptionMap;
    private targetBuildOptionMap;
    initProjectBuildOptions(projectModel: ProjectModel): void;
    initModuleBuildOptions(moduleModel: ModuleModel): void;
    private getBuildOptNameFromMapping;
    getProductBuildOption(product: string): BuildOpt;
    getTargetBuildOption(moduleName: string, target: string): BuildOpt;
    static getBuildMode(): string;
}
export declare const buildOptionManager: BuildModeManager;
