"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,o,i){void 0===i&&(i=o);var s=Object.getOwnPropertyDescriptor(t,o);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[o]}}),Object.defineProperty(e,i,s)}:function(e,t,o,i){void 0===i&&(i=o),e[i]=t[o]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var o in e)"default"!==o&&Object.prototype.hasOwnProperty.call(e,o)&&__createBinding(t,e,o);return __setModuleDefault(t,e),t},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.ArkCompile=void 0;const hvigor_1=require("@ohos/hvigor"),crypto_1=__importDefault(require("crypto")),fse=__importStar(require("fs-extra")),path_1=__importDefault(require("path")),sdk_const_js_1=require("../const/sdk-const.js"),code_type_enum_js_1=require("../enum/code-type-enum.js"),ohos_logger_js_1=require("../utils/log/ohos-logger.js"),obfuscation_config_resolver_js_1=require("../utils/obfuscation-config-resolver.js"),project_file_reader_js_1=require("../utils/project-file-reader.js"),abstract_compile_node_js_1=require("./abstract/abstract-compile-node.js"),task_names_js_1=require("./common/task-names.js"),har_extend_info_js_1=require("./har/har-extend-info.js"),global_project_data_service_js_1=require("./service/global-project-data-service.js"),target_task_service_js_1=require("./service/target-task-service.js"),run_ark_js_1=require("./worker/run-ark.js"),compile_resource_js_1=require("./compile-resource.js"),generate_loader_json_js_1=require("./generate-loader-json.js");var CommonTask=task_names_js_1.TaskNames.CommonTask;const build_directory_const_js_1=require("../const/build-directory-const.js"),common_const_js_1=require("../const/common-const.js"),math_util_js_1=require("../utils/math-util.js"),task_util_js_1=require("../utils/task-util.js");class ArkCompile extends abstract_compile_node_js_1.AbstractCompileNode{constructor(e,t,o){super(e,t,o),this._log=ohos_logger_js_1.OhosLogger.getLogger(ArkCompile.name);const i=e.getTargetData().getModuleSourceSetModel().getModuleTargetRes();this.formJsonPathArr=target_task_service_js_1.TargetTaskService.getFormJsonArr(i),this.needSubmitArkTsWidget=this.shouldCompileArkTsWidget()}taskShouldDo(){return super.taskShouldDo()&&(this.codeType===code_type_enum_js_1.CodeType.ETS?this.sdkInfo.hasRollUpPluginInEtsLoader:this.sdkInfo.hasRollUpPluginInJsLoader)}declareInputs(){var e,t,o,i,s;const r=super.declareInputs().set("arkTsWdiget",this.needSubmitArkTsWidget),a=hvigor_1.hvigor.getExtraConfig().get(common_const_js_1.CommonConst.DEBUG_LINE);a&&r.set(common_const_js_1.CommonConst.DEBUG_LINE,a);const n=null===(i=null===(o=null===(t=null===(e=this.buildOption)||void 0===e?void 0:e.arkOptions)||void 0===t?void 0:t.obfuscation)||void 0===o?void 0:o.ruleOptions)||void 0===i?void 0:i.enable;return r.set(common_const_js_1.CommonConst.OBFUSCATION_ENABLE,String(n)),this.obfuscationOptions&&!this.obfuscationHash&&(this.obfuscationHash=this.computeObfuscationFileHash(this.obfuscationOptions),r.set(common_const_js_1.CommonConst.OBFUSCATION_FILES_HASH,null!==(s=this.obfuscationHash)&&void 0!==s?s:"")),r}async beforeAlwaysAction(){this.obfuscationOptions=await this.getObfuscationOptions()}async beforeTask(){var e,t,o,i;if(await super.beforeTask(),this.targetService.isDebug())return;const s=this.getIncrementalCacheItem(common_const_js_1.CommonConst.OBFUSCATION_ENABLE);if(String(s)!==String(null===(i=null===(o=null===(t=null===(e=this.buildOption)||void 0===e?void 0:e.arkOptions)||void 0===t?void 0:t.obfuscation)||void 0===o?void 0:o.ruleOptions)||void 0===i?void 0:i.enable))return this._log.debug("Clean the arkts cache due to obfuscation config changes."),void await this.cleanCache();this.getIncrementalCacheItem(common_const_js_1.CommonConst.OBFUSCATION_FILES_HASH)!==this.obfuscationHash&&(this._log.debug("Clean the arkts cache due to obfuscation file changes."),await this.cleanCache())}declareInputFiles(){const e=super.declareInputFiles().addEntries(this.formJsonPathArr),t=this.targetService.getTargetData().getTargetName(),o=this.pathInfo.getGenerateBuildProfilePath(t);return fse.existsSync(o)&&e.addEntry(o),this.service.getHarModuleDependencyPaths().forEach((t=>{const o=path_1.default.resolve(t,build_directory_const_js_1.BuildArtifactConst.BUILD_PROFILE_FILE);fse.existsSync(o)&&e.addEntry(o)})),e}async doTaskAction(){this.validateModuleJson(this._log),this.validateMockFilePath();const e=await this.initDefaultArkCompileConfig();this._log.debug("build config:"),this._log.debug(e),e.externalApiPaths.length>0&&this._log.debug(`Compile arkts with external api path: ${e.externalApiPaths.join(path_1.default.delimiter)}`),e.obfuscationOptions&&(await fse.ensureDir(e.obfuscationOptions.obfuscationCacheDir),await fse.ensureDir(path_1.default.dirname(e.obfuscationOptions.exportRulePath))),fse.ensureDirSync(e.cachePath),fse.ensureDirSync(e.aceModuleBuild);let t=null;if(t=await(0,run_ark_js_1.submitArkCompileWork)(this,this.getWorkerPool(),this._log,e,(e=>{this.moveReleaseMap(this.targetData,this._log,this.codeType),this.handleCompileEvents(e,t?this.getSubDurationEvent(t):this.durationEvent,!1)}),0===this.getWorkerPool().getMaxPoolNum()?void 0:[(0,math_util_js_1.mod)((0,hvigor_1.getModuleIndex)(e.modulePath),this.getWorkerPool().getMaxPoolNum())]),this.needSubmitArkTsWidget){const t=await this.initWidgetDefaultArkCompileConfig();t.ignoreWarning=!0;let o=null;o=await(0,run_ark_js_1.submitArkCompileWork)(this,this.getWorkerPool(),this._log,t,(e=>this.handleCompileEvents(e,o?this.getSubDurationEvent(o):this.durationEvent,!1)),0===this.getWorkerPool().getMaxPoolNum()?void 0:[(0,math_util_js_1.mod)((0,hvigor_1.getModuleIndex)(e.modulePath),this.getWorkerPool().getMaxPoolNum())])}(0,task_util_js_1.warnCreateBuildProfileTask)(this.targetData,this.targetService,this._log)}async initDefaultArkCompileConfig(){const e=this.targetData.getModuleModel().getMockConfigPath();return{...await super.initDefaultArkCompileConfig(),projectModel:global_project_data_service_js_1.GlobalProjectDataService.getInstance().getCompileProjectModel(),pkgJsonFileHash:global_project_data_service_js_1.GlobalProjectDataService.getInstance().getProjectPkgJsonFileHash(),obfuscationOptions:this.obfuscationOptions,mockParams:{decorator:"@MockSetup",packageName:"@ohos/hamock",etsSourceRootPath:"src/main/ets",mockConfigPath:fse.existsSync(e)?e:void 0}}}async initWidgetDefaultArkCompileConfig(){return{...await this.initDefaultArkCompileConfig(),widgetCompile:"true",cachePath:this.getTaskTempDir(this.targetData,"_widget")}}shouldCompileArkTsWidget(){return this.formJsonPathArr.some((e=>{var t;let o;try{o=fse.readJsonSync(e)}catch(t){throw new Error(`${e} is not in valid JSON format.`)}return null===(t=o.forms)||void 0===t?void 0:t.some((e=>"arkts"===e.uiSyntax))}))}initTaskDepends(){(0,task_util_js_1.limitMinApiVersion)(this.targetData,sdk_const_js_1.ApiVersion.API_VERSION_9)?(this.declareDependsList(generate_loader_json_js_1.GenerateLoaderJson.name,compile_resource_js_1.CompileResource.name,CommonTask.CREATE_BUILD_PROFILE.name),this.service.getHarModuleDependencyNames().forEach((e=>{this.declareDepends(`default@${CommonTask.CREATE_HAR_BUILD_PROFILE.name}`,e)}))):this.declareDependsList(generate_loader_json_js_1.GenerateLoaderJson.name,compile_resource_js_1.CompileResource.name)}async getObfuscationOptions(){var e,t,o;const i=this.targetService.getBuildOption();if(i.debuggable)return void this._log.debug("Obfuscation config only effect in release mode.");const s=path_1.default.resolve(this.getTaskTempDir(this.targetData),"obfuscation");let r=null===(e=i.arkOptions)||void 0===e?void 0:e.obfuscation;if(i.artifactType&&this._log.warn("buildOption/artifactType is deprecated, please use buildOption/arkOptions/obfuscation instead."),i.artifactType===har_extend_info_js_1.ArtifactType.OBFUSCATION&&void 0===(null===(t=null==r?void 0:r.ruleOptions)||void 0===t?void 0:t.enable)&&(r={...r,ruleOptions:{enable:!0},libDir:this.module.getNodeDir()}),r&&void 0!==(null===(o=r.ruleOptions)||void 0===o?void 0:o.enable)){if(!(this.compileApiVersion<sdk_const_js_1.ApiVersion.API_VERSION_10||this.isFaMode))return(0,obfuscation_config_resolver_js_1.resolveObfuscationOptions)(this.targetService,r,s);this._log.warn(`Obfuscation is supported in stage mode of API${sdk_const_js_1.ApiVersion.API_VERSION_10} or later.`)}}computeObfuscationFileHash(e){var t,o,i,s,r,a,n,l;const u=[];u.push(...null!==(i=null===(o=null===(t=e.selfConfig)||void 0===t?void 0:t.ruleOptions)||void 0===o?void 0:o.rules)&&void 0!==i?i:[]),u.push(...null!==(r=null===(s=e.selfConfig)||void 0===s?void 0:s.consumerRules)&&void 0!==r?r:[]),u.push(...e.dependencies.hars);for(const t of e.dependencies.libraries)u.push(...null!==(n=null===(a=t.ruleOptions)||void 0===a?void 0:a.rules)&&void 0!==n?n:[]),u.push(...null!==(l=t.consumerRules)&&void 0!==l?l:[]);const c=crypto_1.default.createHash("sha256");for(const e of u)fse.existsSync(e)&&c.update(fse.readFileSync(e));return c.digest("hex")}getIncrementalCacheItem(e){var t,o,i;return null===(i=null===(o=null===(t=hvigor_1.ProjectCacheService.getInstance(this.projectModel.getProject()).getTaskSnapShot(this.getName(),this.module))||void 0===t?void 0:t.getInputs())||void 0===o?void 0:o.find((t=>t.getName()===e)))||void 0===i?void 0:i.getValue()}async cleanCache(){const e=this.getTaskTempDir(this.targetData);await fse.emptydir(e);const t=path_1.default.resolve(e,"..",".ts_checker_cache");fse.existsSync(t)&&await fse.rm(t)}validateMockFilePath(){const e=project_file_reader_js_1.ProjectFileReader.getJson5Obj(this.moduleModel.getMockConfigPath());e&&Object.values(e).forEach((e=>{const t=e.source;if(t){const e=path_1.default.resolve(this.moduleModel.getProjectDir(),t);fse.existsSync(e)||this._log._buildError(`source: ${t} not exists.`)._file(this.moduleModel.getMockConfigPath())._printErrorAndExit(this.moduleName)}else this._log._buildError("source key must exist")._file(this.moduleModel.getMockConfigPath())._printErrorAndExit(this.moduleName)}))}}exports.ArkCompile=ArkCompile;