"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.PrepareSharedHarRes=void 0;const hvigor_1=require("@ohos/hvigor"),fs_extra_1=__importDefault(require("fs-extra")),path_1=__importDefault(require("path")),common_const_js_1=require("../../const/common-const.js"),cmake_util_js_1=require("../../utils/cmake-util.js"),ohos_logger_js_1=require("../../utils/log/ohos-logger.js"),npm_utils_js_1=require("../../utils/npm-utils.js"),task_names_js_1=require("../common/task-names.js"),ohos_hap_task_js_1=require("../task/ohos-hap-task.js");var Task=task_names_js_1.TaskNames.Task;const build_directory_const_js_1=require("../../const/build-directory-const.js"),file_util_js_1=require("../../utils/file-util.js"),_log=ohos_logger_js_1.OhosLogger.getLogger("PrepareSharedHarRes"),DECLARE_FILE_OUTPUT="etsFortgz",REGEX_ETS=/(.+)\.ets$/,REGEX_TS=/(.+)\.ts$/,REGEX_D=/(.+)\.d$/;class PrepareSharedHarRes extends ohos_hap_task_js_1.OhosHapTask{constructor(e){var t;super(e,Task.PREPARE_SHARED_HAR_RES),this.INTERFACE_HAR="InterfaceHar",this.ignoreFileList=[build_directory_const_js_1.BuildDirConst.LIBS,build_directory_const_js_1.BuildDirConst.BUILD_ROOT,common_const_js_1.CommonNodeConst.NODE_MODULES,common_const_js_1.CommonConst.OH_MODULES,".cxx",".previewer",".hvigor",".gitignore",".ohpmignore"],this.allInvalidPrefix=[];const s=path_1.default.relative(this.projectModel.getProjectDir(),this.moduleModel.getProjectDir());this.inputPackageJson5Path=e.getTargetData().getModuleModel().getOhPackageJson5Path(),this.inputModuleJsonPath=this.pathInfo.getIntermediatesProcessProfile(),this.inputDeclareFilesPath=path_1.default.resolve(this.pathInfo.getInterMediatesLoaderOutPath(),"etsFortgz",s),this.headerPath=null===(t=this.targetService.getBuildOption().nativeLib)||void 0===t?void 0:t.headerPath,this.libsPath=this.pathInfo.getIntermediatesStrippedLibsDir(),this.taskTmpDir=this.getTaskTempDir(this.targetData,"shared_har",!1),this.outputPackageJsonPath=path_1.default.resolve(this.taskTmpDir,common_const_js_1.CommonConst.OH_PACKAGE_JSON5),this.outputModuleJsonPath=path_1.default.resolve(this.taskTmpDir,"src","main",common_const_js_1.CommonConst.MODULE_JSON),this.outputDeclareFilesPath=this.taskTmpDir,this._moduleDir=this.moduleModel.getProjectDir(),this.initAllInvalidPrefix()}declareInputFiles(){const e=this.allInvalidPrefix.join("|").replace(/\\/g,"\\\\"),t=RegExp(`^(?!${e}).*`),s=super.declareInputFiles().addEntry(this.inputPackageJson5Path).addEntry(this.inputModuleJsonPath).addEntry(this._moduleDir,{isDirectory:!0,test:t}).addEntry(this.libsPath);if(fs_extra_1.default.existsSync(this.inputDeclareFilesPath)&&s.addEntry(this.inputDeclareFilesPath,{isDirectory:!0}),this.headerPath){const e=path_1.default.isAbsolute(this.headerPath)?this.headerPath:path_1.default.resolve(this._moduleDir,this.headerPath);fs_extra_1.default.existsSync(e)&&s.addEntry(e)}return s}declareOutputFiles(){return super.declareOutputFiles().addEntry(this.taskTmpDir,{isDirectory:!0})}initTaskDepends(){this.targetName===common_const_js_1.DefaultTargetConst.OHOS_TEST_TARGET?this.declareDepends("OhosTestCompileArkTS"):this.declareDepends("CompileArkTS"),this.declareDepends(task_names_js_1.TaskNames.Task.DO_NATIVE_STRIP.name)}async doTaskAction(){this.preCheckBeforePack(),this.copyLocalDepsFileToTempDir(),file_util_js_1.FileUtil.copySpecialFileToTempDir(this.moduleModel.getProjectDir(),this.taskTmpDir),fs_extra_1.default.existsSync(this.inputDeclareFilesPath)&&fs_extra_1.default.copySync(this.inputDeclareFilesPath,this.outputDeclareFilesPath),this.generatePackageJson(),this.generateModuleJson(),await this.syncNative()}async syncNative(){if(this.headerPath){const e=path_1.default.isAbsolute(this.headerPath)?this.headerPath:path_1.default.resolve(this._moduleDir,this.headerPath);cmake_util_js_1.CmakeUtil.checkNativeHeader(e,this.moduleModel),fs_extra_1.default.existsSync(e)&&await fs_extra_1.default.copy(e,path_1.default.resolve(this.taskTmpDir,"include"),{recursive:!0})}fs_extra_1.default.existsSync(this.libsPath)&&fs_extra_1.default.readdirSync(this.libsPath).length>0&&await fs_extra_1.default.copy(this.libsPath,path_1.default.resolve(this.taskTmpDir,"libs"),{recursive:!0})}generatePackageJson(){const e=hvigor_1.Json5Reader.getJson5Obj(this.inputPackageJson5Path);e.types=this.getTypesFieldFromMainField(e.main),e.main=void 0,e.packageType&&e.packageType!==this.INTERFACE_HAR&&_log.warn("share library packageType in oh-package.json should use InterfaceHar"),e.packageType||(e.packageType=this.INTERFACE_HAR),fs_extra_1.default.outputJsonSync(this.outputPackageJsonPath,e,{encoding:"utf8",spaces:"  "})}copyLocalDepsFileToTempDir(){(0,npm_utils_js_1.collectLocalFileDependency)(this.inputPackageJson5Path).forEach((e=>{fs_extra_1.default.pathExistsSync(path_1.default.resolve(this.moduleModel.getProjectDir(),e))&&fs_extra_1.default.copySync(path_1.default.resolve(this.moduleModel.getProjectDir(),e),path_1.default.resolve(this.taskTmpDir,e))}))}generateModuleJson(){const e=fs_extra_1.default.readJsonSync(this.inputModuleJsonPath,{encoding:"utf8"});e.app={bundleName:e.app.bundleName,debug:e.app.debug,versionCode:e.app.versionCode,versionName:e.app.versionName,minCompatibleVersionCode:e.app.minCompatibleVersionCode,minAPIVersion:e.app.minAPIVersion,targetAPIVersion:e.app.targetAPIVersion,apiReleaseType:e.app.apiReleaseType},e.module={name:e.module.name,type:e.module.type,deliveryWithInstall:e.module.deliveryWithInstall,deviceTypes:e.module.deviceTypes,requestPermissions:e.module.requestPermissions,dependencies:e.module.dependencies,libIsolation:e.module.libIsolation},fs_extra_1.default.outputJsonSync(this.outputModuleJsonPath,e,{encoding:"utf8"})}getTypesFieldFromMainField(e){return void 0===e?"./src/main/ets/index.d.ets":REGEX_ETS.test(e)?e.replace(REGEX_ETS,"$1.d.ets"):REGEX_TS.test(e)?e.replace(REGEX_TS,"$1.d.ts"):REGEX_D.test(e)?e:`${e}.d`}preCheckBeforePack(){const e=this.moduleModel.getOhPackageJson5Path();return(0,npm_utils_js_1.checkHasLocalFileDependency)(e)&&_log._buildError(`Local dependencies detected during har packing of module ${this.moduleName}. Declaring local dependencies in har module might cause failing during install har package.`)._detail("Check oh-package.json5 file of current shared library module and replace the local dependencies.")._file(e)._printWarn(this.moduleName),fs_extra_1.default.emptyDirSync(this.taskTmpDir),!0}initAllInvalidPrefix(){for(const e of this.ignoreFileList)this.allInvalidPrefix.push(path_1.default.resolve(this._moduleDir,e))}}exports.PrepareSharedHarRes=PrepareSharedHarRes;