"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initCloneObject = exports.cloneDataView = exports.cloneRegExp = exports.cloneSymbol = exports.cloneTypedArray = exports.cloneArrayBuffer = void 0;
var validCheck_1 = require("./validCheck");
var getTag_1 = __importDefault(require("./getTag"));
var copyArray_1 = __importDefault(require("./copyArray"));
var copySymbols_1 = __importStar(require("./copySymbols"));
var copyObject_1 = require("./copyObject");
var keysIn_1 = __importDefault(require("../keysIn"));
var Stack_1 = require("./Stack");
var isTypedArray_1 = __importDefault(require("../isTypedArray"));
var getAllKeys_1 = __importStar(require("./getAllKeys"));
var keys_1 = __importDefault(require("../keys"));
var arrayEach_1 = require("./arrayEach");
var assignUtil_1 = require("./assignUtil");
function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array(result).set(new Uint8Array(arrayBuffer));
    return result;
}
exports.cloneArrayBuffer = cloneArrayBuffer;
function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}
exports.cloneTypedArray = cloneTypedArray;
var symbolValueOf = Symbol.prototype.valueOf;
function cloneSymbol(symbol) {
    return Object(symbolValueOf.call(symbol));
}
exports.cloneSymbol = cloneSymbol;
var reFlags = /\w*$/;
function cloneRegExp(regexp) {
    var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
    result.lastIndex = regexp.lastIndex;
    return result;
}
exports.cloneRegExp = cloneRegExp;
function cloneDataView(dataView, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
    return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}
exports.cloneDataView = cloneDataView;
function initCloneObject(object) {
    return (typeof object.constructor === 'function' && !(0, validCheck_1.isPrototype)(object))
        ? Object.create(Object.getPrototypeOf(object))
        : {};
}
exports.initCloneObject = initCloneObject;
var CLONE_DEEP_FLAG = 1;
var CLONE_FLAT_FLAG = 2;
var CLONE_SYMBOLS_FLAG = 4;
var argsTag = '[object Arguments]';
var arrayTag = '[object Array]';
var boolTag = '[object Boolean]';
var dateTag = '[object Date]';
var errorTag = '[object Error]';
var mapTag = '[object Map]';
var numberTag = '[object Number]';
var objectTag = '[object Object]';
var regexpTag = '[object RegExp]';
var setTag = '[object Set]';
var stringTag = '[object String]';
var symbolTag = '[object Symbol]';
var weakMapTag = '[object WeakMap]';
var arrayBufferTag = '[object ArrayBuffer]';
var dataViewTag = '[object DataView]';
var float32Tag = '[object Float32Array]';
var float64Tag = '[object Float64Array]';
var int8Tag = '[object Int8Array]';
var int16Tag = '[object Int16Array]';
var int32Tag = '[object Int32Array]';
var uint8Tag = '[object Uint8Array]';
var uint8ClampedTag = '[object Uint8ClampedArray]';
var uint16Tag = '[object Uint16Array]';
var uint32Tag = '[object Uint32Array]';
var cloneableTags = {};
cloneableTags[argsTag] = true;
cloneableTags[arrayTag] = true;
cloneableTags[arrayBufferTag] = true;
cloneableTags[dataViewTag] = true;
cloneableTags[boolTag] = true;
cloneableTags[dateTag] = true;
cloneableTags[float32Tag] = true;
cloneableTags[float64Tag] = true;
cloneableTags[int8Tag] = true;
cloneableTags[int16Tag] = true;
cloneableTags[int32Tag] = true;
cloneableTags[mapTag] = true;
cloneableTags[numberTag] = true;
cloneableTags[objectTag] = true;
cloneableTags[regexpTag] = true;
cloneableTags[setTag] = true;
cloneableTags[stringTag] = true;
cloneableTags[symbolTag] = true;
cloneableTags[uint8Tag] = true;
cloneableTags[uint8ClampedTag] = true;
cloneableTags[uint16Tag] = true;
cloneableTags[uint32Tag] = true;
cloneableTags[errorTag] = false;
cloneableTags[weakMapTag] = false;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var cloneTypedKeys = [float32Tag,
    float64Tag,
    int8Tag,
    int16Tag,
    int32Tag,
    uint8Tag,
    uint8ClampedTag,
    uint16Tag,
    uint32Tag];
var ctorObjectPlusKeys = [
    boolTag,
    dateTag,
];
var ctorObjectKeys = [numberTag, stringTag];
function initCloneByTag(object, tag, isDeep) {
    var Ctor = object.constructor;
    if (cloneTypedKeys.includes(tag)) {
        return cloneTypedArray(object, isDeep);
    }
    if (ctorObjectPlusKeys.includes(tag)) {
        return new Ctor(+object);
    }
    if (ctorObjectKeys.includes(tag)) {
        return new Ctor(object);
    }
    switch (tag) {
        case arrayBufferTag:
            return cloneArrayBuffer(object);
        case dataViewTag:
            return cloneDataView(object, isDeep);
        case mapTag:
            return new Ctor;
        case regexpTag:
            return cloneRegExp(object);
        case setTag:
            return new Ctor();
        case symbolTag:
            return cloneSymbol(object);
        default:
            return undefined;
    }
}
function initCloneArray(array) {
    var length = array.length;
    var result = new array.constructor(length);
    if (length && typeof array[0] === 'string' && hasOwnProperty.call(array, 'index')) {
        result.index = array.index;
        result.input = array.input;
    }
    return result;
}
function baseClone(value, bitmask, customizer, key, object, stack) {
    var result;
    var isDeep = bitmask & CLONE_DEEP_FLAG;
    var isFlat = bitmask & CLONE_FLAT_FLAG;
    var isFull = bitmask & CLONE_SYMBOLS_FLAG;
    if (customizer) {
        result = object ? customizer(value, key, object, stack) : customizer(value);
    }
    if (result !== undefined) {
        return result;
    }
    if (!(0, validCheck_1.isObject)(value)) {
        return value;
    }
    var isArr = Array.isArray(value);
    var tag = (0, getTag_1.default)(value);
    if (isArr) {
        result = initCloneArray(value);
        if (!isDeep) {
            return (0, copyArray_1.default)(value, result);
        }
    }
    else {
        var isFunc = typeof value === 'function';
        if (tag === objectTag || tag === argsTag || (isFunc && !object)) {
            result = (isFlat || isFunc) ? {} : initCloneObject(value);
            if (!isDeep) {
                return isFlat
                    ? (0, copySymbols_1.copySymbolsIn)(value, (0, copyObject_1.copyObject)(value, (0, keysIn_1.default)(value), result, false))
                    : (0, copySymbols_1.default)(value, Object.assign(result, value));
            }
        }
        else {
            if (isFunc || !cloneableTags[tag]) {
                return object ? value : {};
            }
            result = initCloneByTag(value, tag, isDeep);
        }
    }
    var tmpStack = stack;
    if (!tmpStack) {
        tmpStack = new Stack_1.Stack(undefined);
    }
    var stacked = tmpStack.get(value);
    if (stacked) {
        return stacked;
    }
    tmpStack.set(value, result);
    if (tag === mapTag) {
        value.forEach(function (subValue, kkey) {
            result.set(kkey, baseClone(subValue, bitmask, customizer, kkey, value, tmpStack));
        });
        return result;
    }
    if (tag === setTag) {
        value.forEach(function (subValue) {
            result.add(baseClone(subValue, bitmask, customizer, subValue, value, tmpStack));
        });
        return result;
    }
    if ((0, isTypedArray_1.default)(value)) {
        return result;
    }
    var keysFunc;
    if (isFull) {
        keysFunc = (isFlat ? getAllKeys_1.getAllKeysIn : getAllKeys_1.default);
    }
    else {
        keysFunc = (isFlat ? keysIn_1.default : keys_1.default);
    }
    var props = isArr ? undefined : keysFunc(value);
    (0, arrayEach_1.arrayEach)(props || value, function (subValue, kkey) {
        var tmpKey = kkey;
        var tmpSubValue = subValue;
        if (props) {
            tmpKey = tmpSubValue;
            tmpSubValue = value[tmpKey];
        }
        // Recursively populate clone (susceptible to call stack limits).
        (0, assignUtil_1.assignValue)(result, tmpKey, baseClone(tmpSubValue, bitmask, customizer, tmpKey, value, tmpStack));
    });
    return result;
}
exports.default = baseClone;
