"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var floor_1 = __importDefault(require("./floor"));
/**
 * 检查value在array数组中首次被找到的索引值
 * @param array
 * @param value
 * @param start（如果start为负值，将从数组array尾端索引进行匹配）
 */
function indexOf(array, value, start) {
    if (start === void 0) { start = 0; }
    if (array === null || array === undefined) {
        return -1;
    }
    var startIndex = Number.isNaN(Number(start)) ? 0 : Number(start);
    startIndex = (0, floor_1.default)(Number(startIndex) < 0 ? Math.max(array.length + Number(startIndex), 0) : startIndex);
    for (var i = startIndex; i < array.length; i++) {
        if ("".concat(array[i]) === "".concat(value)) {
            return i;
        }
    }
    return -1;
}
exports.default = indexOf;
