export declare function getFilters(savedProps: any[]): any[];
/**
 * 获取输入对象的keys，包括以Symbol定义的属性key
 * @param input
 */
export declare function getObjectKeys(input: object): any[];
/**
 * 获取对象的嵌套属性的值
 * @param input
 * @param key
 */
export declare function getNestedValue(input: object, key: string): object;
/**
 * 检查对象属性是否嵌套
 * @param input
 */
export declare function checkIsNestedObject(input: any): boolean;
/**
 * 创建一个从 object 中选中的属性的对象，返回被保留属性后的新对象
 * @param input 来源对象
 * @param savedProps 保留的属性
 */
export default function pick(input: any, ...savedProps: any[]): object;
