"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./common/utils");
/**
 * 从string字符串中移除后面的 空格 或 指定的字符。
 * @param value: 要处理的字符串
 * @param chars: 指定字符
 */
function trimEnd(value, chars) {
    if (value === null || value === undefined) {
        return '';
    }
    var charSet = chars ? new Set(chars.split('')).add(' ') : new Set(utils_1.whiteSpace);
    var array = value.split('');
    var endIndex = -1;
    for (var i = array.length - 1; i >= 0; i--) {
        if (!charSet.has(array[i])) {
            endIndex = i;
            break;
        }
    }
    return array.slice(0, endIndex + 1).join('');
}
exports.default = trimEnd;
