"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,s)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&__createBinding(t,e,r);return __setModuleDefault(t,e),t},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.registryProcessListener=exports.setProcessRemovedFromRegistryTimer=exports.resetProcessTimeOutTimer=exports.setProcessTimeOutTimer=exports.setCurrentProcessState=exports.getCurrentProcessState=void 0;const wdk_1=require("@baize/wdk"),fs_1=__importDefault(require("fs")),path=__importStar(require("path")),process_1=__importDefault(require("process")),daemon_const_js_1=require("../const/daemon-const.js"),hvigor_daemon_log_js_1=require("../log/hvigor-daemon-log.js"),daemon_info_js_1=require("../registry/daemon-info.js"),daemon_info_service_js_1=require("../registry/daemon-info-service.js"),daemon_server_registry_js_1=require("../registry/daemon-server-registry.js"),hvigor_daemon_server_js_1=require("../server/hvigor-daemon-server.js");let timeout,isExiting=!1;const _log=hvigor_daemon_log_js_1.HvigorDaemonLogger.getLogger("daemon");let currentProcessState=daemon_info_js_1.DaemonState.IDLE;function getCurrentProcessState(){return currentProcessState}function setCurrentProcessState(e,t){currentProcessState=e,daemon_server_registry_js_1.defaultDaemonServerRegistry.updateDaemonProcessState(currentProcessState,t)}function setProcessTimeOutTimer(e){timeout=setInterval((()=>{getCurrentProcessState()===daemon_info_js_1.DaemonState.IDLE?(_log.debug("The process will exit automatically because it has been idle for more than 3 hours."),setCurrentProcessState(daemon_info_js_1.DaemonState.STOPPED,"process idle timeout"),handleExit(-1,e)):_log.debug(`The process has not been used for more than 3 hours,' +\n        ' but will not exit because the current status is ${getCurrentProcessState()}`)}),daemon_const_js_1.DAEMON_PROCESS_EXIT_TIME_OUT)}function resetProcessTimeOutTimer(e){void 0!==timeout&&clearInterval(timeout),_log.debug("The process timeout timer will be reset."),setProcessTimeOutTimer(e)}function setProcessRemovedFromRegistryTimer(e){setInterval((()=>{if(!daemon_server_registry_js_1.defaultDaemonServerRegistry.getInfos().some((e=>e.pid===process_1.default.pid))){_log.debug("hvigor daemon: Current process is not found in the registry, the process will automatically exit.");const t="process is broken by user or operating system.",r={...daemon_info_service_js_1.defaultDaemonInfoService.createDefaultDaemonInfo(e.getHttpServer().address(),e.getSessionId()),state:daemon_info_js_1.DaemonState.BROKEN,info:t};daemon_server_registry_js_1.defaultDaemonServerRegistry.setInfo(r.keyId,r),handleExit(-1,e)}else{const t=daemon_server_registry_js_1.defaultDaemonServerRegistry.getDaemonInfoByPid(process_1.default.pid).state;t===daemon_info_js_1.DaemonState.STOPPED||t===daemon_info_js_1.DaemonState.BROKEN?(_log.debug("hvigor daemon: Current process is stopped or broken. The process will exit."),handleExit(-1,e)):_log.debug(`hvigor daemon: Check daemon process existed in registry, daemonStatus=${t}.`)}}),daemon_const_js_1.DAEMON_PROCESS_REMOVED_FROM_REGISTRY_CHECK_TIME)}function handleDaemonLog(){fs_1.default.readdirSync(daemon_const_js_1.DAEMON_LOG_PATH).forEach((e=>{const t=path.resolve(daemon_const_js_1.DAEMON_LOG_PATH,e),r=fs_1.default.statSync(t);if(function(e,t){return e.isFile()&&daemon_const_js_1.DAEMON_LOG_FILE_NAME_PATTEN.test(t)}(r,e)){if(function(e,t){const r=daemon_server_registry_js_1.defaultDaemonServerRegistry.getDaemonInfoByPid(e),o=Date.now(),s=t.getTime();return void 0===r&&o-s>daemon_const_js_1.DAEMON_LOG_FILE_RETENTION_TIME}(function(e){const t=e.indexOf("-"),r=e.indexOf(".");return r<=t?-1:(0,wdk_1.toNumber)(e.substring(t+1,r))}(e),r.mtime))try{fs_1.default.unlinkSync(t),_log.debug(`Delete log file, logPath=${t}.`)}catch(e){_log.debug(`Cannot delete log file. The file may be opened by another program. logPath=${t}, errorMessage=${e.message}`)}}}))}function registryProcessListener(e){process_1.default.on("exit",(t=>{_log.debug("hvigor daemon: Daemon process exit."),getCurrentProcessState()===daemon_info_js_1.DaemonState.STOPPED&&getCurrentProcessState()===daemon_info_js_1.DaemonState.BROKEN||setCurrentProcessState(daemon_info_js_1.DaemonState.STOPPED,`stopped by exit event with code: ${t}`),handleExit(t,e)}));const t=(t,r)=>{setCurrentProcessState(daemon_info_js_1.DaemonState.STOPPED,`stopped by signal: ${t}`),handleExit(t,e,r)};process_1.default.on("SIGHUP",(()=>t(129))),process_1.default.on("SIGINT",(()=>t(130))),process_1.default.on("SIGTERM",(()=>t(143))),process_1.default.on("SIGBREAK",(()=>t(149))),process_1.default.on("uncaughtException",(e=>t(1,e))),process_1.default.on("unhandledRejection",(e=>t(1,e)))}function handleExit(e,t,r){if(isExiting)return;isExiting=!0;let o=!1;r&&(_log.error(`hvigor daemon: Exit with error: ${r}`),r instanceof Error&&r.stack&&_log.error(`hvigor daemon: Stack: ${r.stack}`)),t.emit(hvigor_daemon_server_js_1.DaemonServerEventName.CLOSE_SERVER,r),handleDaemonLog(),setTimeout((()=>{_log.debug("hvigor daemon: Set process exit timeout in 1000 ms."),_log.debug(`hvigor daemon: Daemon process exit. exitCode=${e}`),o||(o=!0,setImmediate((()=>process_1.default.exit(e))))}),1e3)}exports.getCurrentProcessState=getCurrentProcessState,exports.setCurrentProcessState=setCurrentProcessState,exports.setProcessTimeOutTimer=setProcessTimeOutTimer,exports.resetProcessTimeOutTimer=resetProcessTimeOutTimer,exports.setProcessRemovedFromRegistryTimer=setProcessRemovedFromRegistryTimer,exports.registryProcessListener=registryProcessListener;