"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.hvigorProcess=void 0;const wdk_1=require("@baize/wdk"),cluster_1=__importDefault(require("cluster")),events_1=__importDefault(require("events")),fs_extra_1=__importDefault(require("fs-extra")),path_1=__importDefault(require("path")),process_1=__importDefault(require("process")),wrapper_const_js_1=require("../../../cli/wrapper/wrapper-const.js"),path_util_js_1=require("../../../common/util/path-util.js"),replacer_js_1=require("../../../common/util/replacer.js"),report_service_impl_js_1=require("../../common/report/report-service-impl.js"),trace_build_analyze_js_1=require("../../common/trace/trace-build-analyze.js"),watch_config_file_js_1=require("../../daemon/cluster/watch-config-file.js"),worker_process_event_id_js_1=require("../../daemon/cluster/worker-process-event-id.js"),hvigor_js_1=require("../../external/core/hvigor.js"),default_tooling_model_bean_registry_js_1=require("../../external/default-tooling-model-bean-registry.js"),hvigor_log_js_1=require("../../log/hvigor-log.js"),mark_event_js_1=require("../../metrics/event/mark-event.js"),metric_factory_js_1=require("../../metrics/metric-factory.js"),metric_service_js_1=require("../../metrics/metric-service.js"),time_util_js_1=require("../../util/time-util.js"),project_cache_service_js_1=require("../cache/project-cache-service.js"),global_data_js_1=require("../data/global-data.js"),global_data_js_2=require("../data/global-data.js"),tcb_store_js_1=require("../pool/store/tcb-store.js"),worker_pool_factory_js_1=require("../pool/worker-pool/worker-pool-factory.js"),task_control_center_js_1=require("../task/core/task-control-center.js"),task_directed_acyclic_graph_js_1=require("../task/core/task-directed-acyclic-graph.js"),event_id_options_js_1=require("./event/event-id-options.js"),sync_js_1=require("./sync.js"),_log=hvigor_log_js_1.HvigorLogger.getLogger("hvigor-process");class HvigorBuildProcess extends events_1.default{constructor(){super(),this.hasTaskDone=!1,process_1.default.on("message",(e=>{e.type===event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FAILED&&this.emit(event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FAILED)}))}init(){this.once(event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FINISHED,(()=>{hvigorProcessListenerFactory.getProcessListenerByEventName(event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FINISHED)()})),this.once(event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FAILED,(()=>{hvigorProcessListenerFactory.getProcessListenerByEventName(event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FAILED)()}))}setTaskBeginTime(){this.taskBeginTime=process_1.default.hrtime()}close(){this.hasTaskDone=!1,_log.debug("hvigor build process will be closed."),this.removeAllListeners()}error(e,t){var r;const s=null!=t?t:_log;s.debug("hvigor build process will be closed with an error."),s.error(null!==(r=null==e?void 0:e.message)&&void 0!==r?r:e),e.stack&&(global_data_js_1.startParameters.printStackTrace?s.error(e.stack):(s.debug("ERROR: stacktrace =",e.stack),_log._printStackErrorToFile(e.stack))),exports.hvigorProcess.emit(event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FAILED)}}class HvigorProcessListenerFactory{getProcessListenerByEventName(e){switch(e){case event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FINISHED:return this.getFinishedEventListener();case event_id_options_js_1.HVIGOR_PROCESS_EVENT_ID.FAILED:return this.getFailedEventListener();default:return wdk_1.noop}}getFailedEventListener(){return()=>{const e=global_data_js_2.globalData.cliEnv,t=process_1.default.hrtime(exports.hvigorProcess.taskBeginTime);this.historyDataRecord(exports.hvigorProcess.taskBeginTime,mark_event_js_1.MarkEventState.FAILED);const r=(0,time_util_js_1.formatTime)(t);_log.error(`BUILD FAILED in ${r}`),process_1.default.exitCode=-1,wrapUpBeforeExit(e.cwd,1e9*t[0]+t[1]),cluster_1.default.isWorker&&process_1.default.send({type:worker_process_event_id_js_1.WORKER_PROCESS_EVENT_ID.FAILED}),exitHvigor(process_1.default.exitCode)}}getFinishedEventListener(){const e=global_data_js_2.globalData.cliOpts,t=global_data_js_2.globalData.cliEnv;return e.sync?()=>{(0,sync_js_1.outputPluginSyncInfo)(),cluster_1.default.isWorker&&process_1.default.send({type:worker_process_event_id_js_1.WORKER_PROCESS_EVENT_ID.FINISHED}),exitHvigor()}:()=>{var e;const r=process_1.default.hrtime(exports.hvigorProcess.taskBeginTime),s=(0,time_util_js_1.formatTime)(r);let o=mark_event_js_1.MarkEventState.SUCCESS;if(exports.hvigorProcess.hasTaskDone)_log.info(`BUILD SUCCESSFUL in ${s}`);else{const t=global_data_js_2.globalData.cliOpts;_log.error(`Task '${t._}' not found in root project '${null===(e=hvigor_js_1.hvigor.getProject())||void 0===e?void 0:e.getName()}'. Invalid command to execute the build task, please verify the parameters in the command and try again.`),_log.info("* Try the following:\n> Run 'hvigorw --help' to learn more about hvigor command.\n> Run 'hvigorw tasks' to get a list of available tasks.\n> Run the command with '--info' or '--debug' option to get more log output.\n"),_log.error(`BUILD FAILED in ${s}`),o=mark_event_js_1.MarkEventState.FAILED}this.historyDataRecord(exports.hvigorProcess.taskBeginTime,o),wrapUpBeforeExit(t.cwd,1e9*r[0]+r[1]),cluster_1.default.isWorker&&process_1.default.send({type:worker_process_event_id_js_1.WORKER_PROCESS_EVENT_ID.FINISHED}),exitHvigor()}}historyDataRecord(e,t){if(!e)return;const r=global_data_js_2.globalData.cliOpts._.toString(),s="clean"!==r,o=metric_factory_js_1.MetricFactory.createMarkEvent(r,"");let _;_=global_data_js_1.startParameters.daemon?global_data_js_2.globalData.cliOpts.completeCommand:process_1.default.argv.slice(2).join(" "),o.setCompleteCommand(`${JSON.stringify(global_data_js_2.globalData.cliOpts)};${null!=_?_:r}`),o.setHvigorVersion(wrapper_const_js_1.CUR_HVIGOR_VERSION),o.setMarkType(mark_event_js_1.MarkEventType.HISTORY),o.setCategory(s?mark_event_js_1.MarkEventCategory.BUILD:mark_event_js_1.MarkEventCategory.CLEAN),o.start(mark_event_js_1.MarkEventState.RUNNING,this.resolveTaskTime(e)),o.stop(t)}resolveTaskTime(e){return e&&e[0]&&e[1]?1e9*e[0]+e[1]:0}}const hvigorProcessListenerFactory=new HvigorProcessListenerFactory;function traceEnd(e,t){trace_build_analyze_js_1.hvigorTrace.totalTime=t;const r=path_util_js_1.PathUtil.getHvigorCacheDir(_log),s="./outputs/logs/details";fs_extra_1.default.existsSync(path_1.default.resolve(r,s))||fs_extra_1.default.mkdirSync(path_1.default.resolve(r,s),{recursive:!0});try{fs_extra_1.default.writeFileSync(path_1.default.resolve(r,s,"details.json"),JSON.stringify(trace_build_analyze_js_1.traceBuildAnalyze.getData(),replacer_js_1.replacer,2))}catch(e){}}function clearProcessContext(){metric_service_js_1.MetricService.getInstance().clear(),task_directed_acyclic_graph_js_1.projectTaskDag.clear(),task_control_center_js_1.taskControlCenter.clear(),default_tooling_model_bean_registry_js_1.defaultModelRegistry.clear(),hvigor_js_1.hvigor.reset(),exports.hvigorProcess.close(),(0,global_data_js_1.resetStartData)()}function wrapUpBeforeExit(e,t){const r=hvigor_js_1.hvigor.getProject();if(project_cache_service_js_1.ProjectCacheService.getInstance(r).close(),traceEnd(e,t),global_data_js_1.startParameters.analyze!==global_data_js_1.AnalyzeMode.FALSE){report_service_impl_js_1.ReportServiceImpl.getInstance().report()}}function exitHvigor(e){global_data_js_1.startParameters.daemon||process_1.default.exit(e),setImmediate((()=>{const e=e=>{e&&tcb_store_js_1.TcbStore.clear()};worker_pool_factory_js_1.WorkerPoolFactory.getDefaultWorkerPool().isResident()?worker_pool_factory_js_1.WorkerPoolFactory.getDefaultWorkerPool().recycle().then(e):worker_pool_factory_js_1.WorkerPoolFactory.getDefaultWorkerPool().terminate().then(e),clearProcessContext()})),(0,watch_config_file_js_1.setRunning)(!1)}exports.hvigorProcess=new HvigorBuildProcess;