"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.DBCSEncoding=void 0;const models_js_1=require("../models.js"),index_js_1=require("./tables/index.js"),UNASSIGNED=-1,GB18030_CODE=-2,SEQ_START=-10,NODE_START=-1e3,UNASSIGNED_NODE=new Array(256),DEF_CHAR=-1;for(let e=0;e<256;e++)UNASSIGNED_NODE[e]=-1;class DBCSCodec{constructor(e){if(this.decoder=DBCSDecoder,this.encoder=DBCSEncoder,this.encodingName=e.encodingName,!e)throw new Error("DBCS codec is called without the data.");if(!e.table)throw new Error(`Encoding '${this.encodingName}' has no data.`);const t=e.table();this.decodeTables=[],this.decodeTables[0]=UNASSIGNED_NODE.slice(0),this.decodeTableSeq=[];for(let e=0;e<t.length;e++)this.addDecodeChunk(t[e]);this.defaultCharUnicode=models_js_1.defaultCharUnicode,this.encodeTable=[],this.encodeTableSeq=[];this.fillEncodeTable(0,0,{}),this.defCharSB=this.encodeTable[0][models_js_1.defaultCharSingleByte.charCodeAt(0)],-1===this.defCharSB&&(this.defCharSB=this.encodeTable[0]["?"]),-1===this.defCharSB&&(this.defCharSB="?".charCodeAt(0))}addDecodeChunk(e){let t=parseInt(e[0],16);const o=this.getDecodeTrieNode(t);t&=255;for(let s=1;s<e.length;s++){const d=e[s];if("string"==typeof d)for(let s=0;s<d.length;){const n=d.charCodeAt(s++);if(55296<=n&&n<56320){const r=d.charCodeAt(s++);if(!(56320<=r&&r<57344))throw new Error(`Incorrect surrogate pair in ${this.encodingName} at chunk ${e[0]}`);o[t++]=65536+1024*(n-55296)+(r-56320)}else if(4080<n&&n<=4095){const e=4095-n+2,r=[];for(let t=0;t<e;t++)r.push(d.charCodeAt(s++));o[t++]=-10-this.decodeTableSeq.length,this.decodeTableSeq.push(r)}else o[t++]=n}else{if("number"!=typeof d)throw new Error(`Incorrect type '${typeof d}' given in ${this.encodingName} at chunk ${e[0]}`);{let e=o[t-1]+1;for(let s=0;s<d;s++)o[t++]=e++}}}if(t>255)throw new Error(`Incorrect chunk in ${this.encodingName} at addr ${e[0]}: too long${t}`)}getDecodeTrieNode(e){const t=[];for(;e>0;e>>>=8)t.push(255&e);0===t.length&&t.push(0);let o=this.decodeTables[0];for(let s=t.length-1;s>0;s--){const d=o[t[s]];if(-1===d)o[t[s]]=-1e3-this.decodeTables.length,this.decodeTables.push(o=UNASSIGNED_NODE.slice(0));else{if(!(d<=-1e3))throw new Error(`Overwrite byte in ${this.encodingName}, addr: ${e.toString(16)}`);o=this.decodeTables[-1e3-d]}}return o}fillEncodeTable(e,t,o){const s=this.decodeTables[e];let d=!1;const n={};for(let e=0;e<256;e++){const r=s[e],i=t+e;if(!o[i])if(r>=0)this.setEncodeChar(r,i),d=!0;else if(r<=-1e3){const e=-1e3-r;if(!n[e]){const t=i<<8>>>0;this.fillEncodeTable(e,t,o)?d=!0:n[e]=!0}}else r<=-10&&(this.setEncodeSequence(this.decodeTableSeq[-10-r],i),d=!0)}return d}setEncodeChar(e,t){const o=this.getEncodeBucket(e),s=255&e;o[s]<=-10?this.encodeTableSeq[-10-o[s]][-1]=t:-1===o[s]&&(o[s]=t)}setEncodeSequence(e,t){let o=e[0];const s=this.getEncodeBucket(o),d=255&o;let n={};s[d]<=-10?n=this.encodeTableSeq[-10-s[d]]:(-1!==s[d]&&(n[-1]=s[d]),s[d]=-10-this.encodeTableSeq.length,this.encodeTableSeq.push(n));for(let t=1;t<e.length-1;t++){const e=n[o];"object"==typeof e?n=e:(n=n[o]={},void 0!==e&&(n[-1]=e))}o=e[e.length-1],n[o]=t}getEncodeBucket(e){const t=e>>8;return void 0===this.encodeTable[t]&&(this.encodeTable[t]=UNASSIGNED_NODE.slice(0)),this.encodeTable[t]}}class DBCSDecoder{constructor(e,t){this.nodeIdx=0,this.prevBytes=[],this.decodeTables=t.decodeTables,this.decodeTableSeq=t.decodeTableSeq,this.defaultCharUnicode=t.defaultCharUnicode}write(e){const t=Buffer.alloc(2*e.length);let o=this.nodeIdx;const s=this.prevBytes,d=this.prevBytes.length;let n,r=-this.prevBytes.length,i=0;for(let c=0;c<e.length;c++){const h=c>=0?e[c]:s[c+d];if(n=this.decodeTables[o][h],n>=0);else if(-1===n)n=this.defaultCharUnicode.charCodeAt(0),c=r;else{if(n<=-1e3){o=-1e3-n;continue}if(!(n<=-10))throw new Error(`iconv error: invalid decoding table value ${n} at ${o}/${h}`);{const e=this.decodeTableSeq[-10-n];for(let o=0;o<e.length-1;o++)n=e[o],t[i++]=255&n,t[i++]=n>>8;n=e[e.length-1]}}if(n>=65536){n-=65536;const e=55296|n>>10;t[i++]=255&e,t[i++]=e>>8,n=56320|1023&n}t[i++]=255&n,t[i++]=n>>8,o=0,r=c+1}return this.nodeIdx=o,this.prevBytes=r>=0?Array.prototype.slice.call(e,r):s.slice(r+d).concat(Array.prototype.slice.call(e)),t.slice(0,i).toString("ucs2")}end(){let e="";for(;this.prevBytes.length>0;){e+=this.defaultCharUnicode;const t=this.prevBytes.slice(1);this.nodeIdx=0,this.prevBytes=[],t.length>0&&(e+=this.write(Buffer.from(t)))}return this.prevBytes=[],this.nodeIdx=0,e}findIdx(e,t){if(e[0]>t)return-1;let o=0,s=e.length;for(;o<s-1;){const d=o+(s-o+1>>1);e[d]<=t?o=d:s=d}return o}}class DBCSEncoder{constructor(e,t){this.leadSurrogate=-1,this.seqObj=void 0,this.encodeTable=t.encodeTable,this.encodeTableSeq=t.encodeTableSeq,this.defaultCharSingleByte=t.defCharSB}write(e){const t={str:e,newBuf:Buffer.alloc(3*e.length),leadSurrogate:this.leadSurrogate,seqObj:this.seqObj,nextChar:-1,i:0,j:0,uCode:void 0};for(;-1!==t.nextChar||t.i!==e.length;)if(this.getNextCharCode(t),void 0!==t.seqObj&&-1!==t.uCode&&this.handleSeqObj(t),t.uCode>=0){const e=this.getDbcsCode(t);this.writeDbcs(t,e)}return this.seqObj=t.seqObj,this.leadSurrogate=t.leadSurrogate,t.newBuf.slice(0,t.j)}getNextCharCode(e){-1===e.nextChar?e.uCode=e.str.charCodeAt(e.i++):(e.uCode=e.nextChar,e.nextChar=-1),55296<=e.uCode&&e.uCode<57344?e.uCode<56320?e.leadSurrogate=e.uCode:-1!==e.leadSurrogate?(e.uCode=65536+1024*(e.leadSurrogate-55296)+(e.uCode-56320),e.leadSurrogate=-1):e.uCode=-1:-1!==e.leadSurrogate&&(e.leadSurrogate=-1,e.nextChar=e.uCode,e.uCode=-1)}handleSeqObj(e){let t=e.seqObj[e.uCode];"object"==typeof t?e.seqObj=t:"number"==typeof t?e.seqObj=void 0:void 0===t&&(t=e.seqObj[-1],void 0!==t&&(e.seqObj=void 0,e.nextChar=e.uCode,e.uCode=t))}getDbcsCode(e){let t=-1;const o=this.encodeTable[e.uCode>>8];return void 0!==o&&(t=o[255&e.uCode]),t<=-10?(e.seqObj=this.encodeTableSeq[-10-t],-1):(-1===t&&(t=this.defaultCharSingleByte),t)}writeDbcs(e,t){t<256?e.newBuf[e.j++]=t:t<65536?(e.newBuf[e.j++]=t>>8,e.newBuf[e.j++]=255&t):t<16777216?(e.newBuf[e.j++]=t>>16,e.newBuf[e.j++]=t>>8&255,e.newBuf[e.j++]=255&t):(e.newBuf[e.j++]=t>>>24,e.newBuf[e.j++]=t>>>16&255,e.newBuf[e.j++]=t>>>8&255,e.newBuf[e.j++]=255&t)}end(){if(-1===this.leadSurrogate&&void 0===this.seqObj)return;const e=Buffer.alloc(10);let t=0;if(this.seqObj){const o=this.seqObj[-1];void 0!==o&&(o<256?e[t++]=o:(e[t++]=o>>8,e[t++]=255&o)),this.seqObj=void 0}return-1!==this.leadSurrogate&&(e[t++]=this.defaultCharSingleByte,this.leadSurrogate=-1),e.slice(0,t)}}exports.DBCSEncoding={gbk:{type:"_dbcs",table:function(){return(0,index_js_1.tableInit)("cp936.json").concat((0,index_js_1.tableInit)("gbk-added.json"))}},_dbcs:DBCSCodec};