"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var stringToPaths_1 = __importDefault(require("./common/stringToPaths"));
var plainPropsKeyReg = /^\w+$/;
function baseGet(obj, path) {
    var paths;
    if (Array.isArray(path)) {
        paths = path;
    }
    else if (plainPropsKeyReg.test(path) || path in Object(obj)) {
        paths = [path];
    }
    else {
        paths = (0, stringToPaths_1.default)(path);
    }
    var i = 0;
    var result = obj;
    var length = paths.length;
    while (result != null && i < paths.length) {
        result = result[paths[i++]];
    }
    // return result when finished iteration
    return (i && i === length) ? result : undefined;
}
/**
 * 从指定对象按path 获取值。如果获取不到值，则返回默认值
 **
 * @param {Array|string} path 设置值的属性路径
 * @param obj
 * @param {string | string[]} path 设置值的属性路径
 * @param defaultVal
 * @returns 返回 path存在时返回path对应的value，或者返回defaultVal
 */
function get(obj, path, defaultVal) {
    var result = obj == null ? undefined : baseGet(obj, path);
    return result === undefined ? defaultVal : result;
}
exports.default = get;
