import { InvokeOptions } from './debounce';
/**
 * 节流 API，使用如下：
 * 1、生成节流函数 throttled：throttle(log, 250, { leading: false });
 * 2、事件绑定到节流函数上：addEventListener('resize', throttled);
 * 上面 throttled 在事件每次触发时都会执行，log 是待执行的实际方法 func，在等待时间内只执行一次，达到节流作用
 *
 * @param func 待执行的实际方法
 * @param wait 等待时间
 * @param options 设置项，参考 InvokeOptions 接口定义
 */
declare const throttle: (func: Function, wait?: number, options?: InvokeOptions) => {
    (...args: any[]): any;
    flush: () => any;
    cancel: () => void;
    pending: () => boolean;
};
export default throttle;
