/** @type {import('ts-jest/dist/types').InitialOptionsTsJest} */
module.exports = {
  preset: 'ts-jest',
  testEnvironment: 'node',
  maxConcurrency: 3,
  maxWorkers: 2,
  testPathIgnorePatterns: [
    '/node_modules/',
    '/test/resources/',
    '/test/temp/'
  ],
  testTimeout: 1000000,
  testMatch: [
    '**/__tests__/**/*.ts?(x)',
    '**/?(*.)?(long|unit)+(spec|test).ts?(x)'
  ],
  collectCoverageFrom: [
    '**/src/**/*.js'
  ],
  coverageReporters: ['json']
};
