import { OhosHapTask } from '@ohos/hvigor-ohos-plugin/src/tasks/task/ohos-hap-task.js';
import { TargetTaskService } from '@ohos/hvigor-ohos-plugin/src/tasks/service/target-task-service.js';
import { TaskDetails } from '@ohos/hvigor';
import { PathInfo as CrossPlatformPathInfo } from '../../common/util/path-info.js';
import { SdkPathInfo } from '../../common/util/sdk-path-info.js';
/**
 * 基于OhosHapTask定义跨平台任务抽象基类
 *
 * @since 2022/11/28
 */
export declare abstract class BaseOhosModuleTask extends OhosHapTask {
    readonly crossPlatformPathInfo: CrossPlatformPathInfo;
    readonly arkUIXSdkInfo: SdkPathInfo;
    readonly targetService: TargetTaskService;
    protected constructor(targetService: TargetTaskService, taskDetails: TaskDetails);
    doTaskAction(): Promise<void>;
    /**
     * 在当前节点添加Task依赖
     *
     * @param {string[]} preTaskNames 依赖名称
     */
    addDependsTasks(...preTaskNames: string[]): void;
}
