"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 返回对目标数字进行范围限制后的数
 * @param number，目标数字
 * @param lower，范围的下限
 * @param upper，范围的上限
 * @return number  如果目标数字在限制范围之间则返回目标数字，若低于lower则返回lower，若高于upper则返回upper
 */
function clamp(number, lower, upper) {
    if (Number.isNaN(number)) {
        return NaN;
    }
    var num = Number(number);
    var min = upper !== undefined ? Number(lower) : -Infinity;
    var max = upper !== undefined ? Number(upper) : Number(lower);
    if (Number.isNaN(min)) {
        min = 0;
    }
    if (Number.isNaN(max)) {
        max = 0;
    }
    if (num < min) {
        return min;
    }
    else if (num <= max) {
        return num;
    }
    return max;
}
exports.default = clamp;
