"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.equalObjects = void 0;
var getAllKeys_1 = __importDefault(require("./getAllKeys"));
var COMPARE_PARTIAL_FLAG = 1;
var objectProto = Object.prototype;
var hasOwnProperty = objectProto.hasOwnProperty;
function compareContructor(resultParam, skipCtor, obj, other) {
    var result = resultParam;
    if (result && !skipCtor) {
        var objCtor = obj.constructor;
        var othCtor = other.constructor;
        if (objCtor !== othCtor
            && ('constructor' in obj && 'constructor' in other)
            && !(typeof objCtor === 'function' && objCtor instanceof objCtor
                && typeof othCtor === 'function' && othCtor instanceof othCtor)) {
            result = false;
        }
    }
    return result;
}
function compareRecusive(isPartial, indexParam, objLength, keyParam, objProps, obj, other, customizer, stack, equalFunc, bitmask, resultParam) {
    var index = indexParam;
    var key = keyParam;
    var result = resultParam;
    var skipCtor = isPartial;
    while (++index < objLength) {
        key = objProps[index];
        var objValue = obj[key];
        var othValue = other[key];
        var compared = void 0;
        if (customizer) {
            compared = isPartial
                ? customizer(othValue, objValue, key, other, obj, stack)
                : customizer(objValue, othValue, key, obj, other, stack);
        }
        // 递归对比对象是否相等
        if (!(compared === undefined
            ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
            : compared)) {
            result = false;
            break;
        }
        if (!skipCtor) {
            skipCtor = key === 'constructor';
        }
    }
    return {
        skipCtor: skipCtor,
        index: index,
        key: key,
        result: result,
    };
}
// 比较对象是否相等
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
    var objProps = (0, getAllKeys_1.default)(object);
    var objLength = objProps.length;
    var othProps = (0, getAllKeys_1.default)(other);
    var othLength = othProps.length;
    if (objLength !== othLength && !isPartial) {
        return false;
    }
    var index = objLength;
    var key;
    while (index--) {
        key = objProps[index];
        if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
            return false;
        }
    }
    // 检查递归引用
    var objStacked = stack.get(object);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
        return objStacked === other && othStacked === object;
    }
    var result = true;
    stack.set(object, other);
    stack.set(other, object);
    var ret = compareRecusive(isPartial, index, objLength, key, objProps, object, other, customizer, stack, equalFunc, bitmask, result);
    var skipCtor = ret.skipCtor;
    result = ret.result;
    result = compareContructor(result, skipCtor, object, other);
    stack.delete(object);
    stack.delete(other);
    return result;
}
exports.equalObjects = equalObjects;
